/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.style.closebutton;

import ch.swingfx.twinkle.style.closebutton.ICloseButton;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class RectangleCloseButton
implements ICloseButton {
    private static final int DEFAULT_Y = 9;
    private static final int DEFAULT_X = 9;
    private static final int SIZE = 16;
    public static final int TOP_LEFT = 5;
    public static final int BOTTOM_RIGHT = 11;
    public static final int STROKE_WIDTH = 1;
    private Rectangle fButtonShape;
    private int fX;
    private int fY;
    private final BasicStroke fStroke;
    private final Color fButtonBorderColor;
    private final Color fButtonBackgroundColor;

    public RectangleCloseButton(Color buttonBackgroundColor, Color buttonBorderColor) {
        this(buttonBackgroundColor, buttonBorderColor, 9, 9);
    }

    public RectangleCloseButton(Color buttonBackgroundColor, Color buttonBorderColor, int x, int y) {
        this.withPosition(x, y);
        this.fStroke = new BasicStroke(1.0f);
        this.fButtonBackgroundColor = buttonBackgroundColor;
        this.fButtonBorderColor = buttonBorderColor;
    }

    public void paintCloseButton(Graphics g) {
        Graphics2D copy = (Graphics2D)g.create();
        copy.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        copy.setColor(this.fButtonBackgroundColor);
        copy.fill(this.fButtonShape);
        copy.setStroke(this.fStroke);
        copy.setColor(this.fButtonBorderColor);
        copy.draw(this.fButtonShape);
        copy.drawLine(this.fX + 5, this.fY + 5, this.fX + 11, this.fY + 11);
        copy.drawLine(this.fX + 11, this.fY + 5, this.fX + 5, this.fY + 11);
        copy.dispose();
    }

    public boolean isMouseOverCloseButton(Point mousePosition) {
        if (mousePosition == null || this.fButtonShape == null) {
            return false;
        }
        return this.fButtonShape.contains(mousePosition);
    }

    public ICloseButton withPosition(int x, int y) {
        this.fX = x;
        this.fY = y;
        this.fButtonShape = new Rectangle(this.fX, this.fY, 16, 16);
        return this;
    }
}

