/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.style.background;

import ch.swingfx.color.ColorUtil;
import ch.swingfx.twinkle.style.background.IBackground;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;

public class ColorBackground
implements IBackground {
    private Color fColor;

    public ColorBackground(Color color) {
        this.fColor = color;
    }

    public void paintBackground(Graphics g, boolean isMouseOver, int cornerRadius) {
        Graphics2D copy = (Graphics2D)g.create();
        Shape clip = copy.getClip();
        copy.setColor(this.fColor);
        copy.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (cornerRadius == 0) {
            copy.fill(clip);
        } else {
            copy.fill(new RoundRectangle2D.Double(0.0, 0.0, clip.getBounds().getWidth(), clip.getBounds().getHeight(), cornerRadius, cornerRadius));
        }
        copy.dispose();
    }

    public void setAlpha(float alpha) {
        this.fColor = ColorUtil.withAlpha((Color)this.fColor, (float)alpha);
    }
}

