/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.style;

import ch.swingfx.twinkle.style.INotificationStyle;
import ch.swingfx.twinkle.style.background.ColorBackground;
import ch.swingfx.twinkle.style.background.IBackground;
import ch.swingfx.twinkle.style.closebutton.ICloseButton;
import ch.swingfx.twinkle.style.closebutton.NullCloseButton;
import ch.swingfx.twinkle.style.overlay.IOverlay;
import ch.swingfx.twinkle.style.overlay.NullOverlay;
import ch.swingfx.twinkle.window.ICreateNotificationWindow;
import ch.swingfx.twinkle.window.NotificationWindowTypes;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNotificationStyle
implements INotificationStyle {
    private Font fTitleFont = null;
    private Font fMessageFont = null;
    private Color fTitleFontColor = Color.WHITE;
    private Color fMessageFontColor = Color.WHITE;
    private Insets fWindowInsets = null;
    private int fWindowWidth = 320;
    private float fAlpha = 1.0f;
    private ICloseButton fCloseButton;
    private IOverlay fOverlay;
    private IBackground fBackground;
    private int fWindowCornerRadius;
    private ICreateNotificationWindow fWindowCreator;
    private Map<String, Object> fCustomParams;

    public AbstractNotificationStyle() {
        Font font = new JLabel().getFont();
        this.fWindowCornerRadius = 0;
        this.fCustomParams = new HashMap<String, Object>();
        this.fBackground = new ColorBackground(Color.GRAY);
        this.fTitleFont = font.deriveFont(13.0f).deriveFont(1);
        this.fMessageFont = font.deriveFont(12.0f).deriveFont(0);
        this.fWindowInsets = new Insets(10, 10, 10, 10);
        this.fOverlay = new NullOverlay();
        this.fCloseButton = new NullCloseButton();
        this.fWindowCreator = NotificationWindowTypes.DEFAULT;
    }

    public AbstractNotificationStyle withWidth(int width) {
        this.fWindowWidth = width;
        return this;
    }

    public AbstractNotificationStyle withWindowCornerRadius(int cornerRadius) {
        if (cornerRadius < 0) {
            throw new RuntimeException("Window corner radius must be >= 0");
        }
        this.fWindowCornerRadius = cornerRadius;
        return this;
    }

    public AbstractNotificationStyle withWindowInsets(Insets windowInsets) {
        this.fWindowInsets = windowInsets;
        return this;
    }

    public AbstractNotificationStyle withTitleFont(Font titleFont) {
        this.fTitleFont = titleFont;
        return this;
    }

    public AbstractNotificationStyle withMessageFont(Font messageFont) {
        this.fMessageFont = messageFont;
        return this;
    }

    public AbstractNotificationStyle withAlpha(float alpha) {
        this.fAlpha = alpha;
        this.getBackground().setAlpha(alpha);
        return this;
    }

    public AbstractNotificationStyle withBackground(IBackground background) {
        this.fBackground = background;
        background.setAlpha(this.getAlpha());
        return this;
    }

    public AbstractNotificationStyle withTitleFontColor(Color color) {
        this.fTitleFontColor = color;
        return this;
    }

    public AbstractNotificationStyle withMessageFontColor(Color color) {
        this.fMessageFontColor = color;
        return this;
    }

    public AbstractNotificationStyle withOverlay(IOverlay overlay) {
        this.fOverlay = overlay;
        return this;
    }

    public AbstractNotificationStyle withCloseButton(ICloseButton closeButton) {
        this.fCloseButton = closeButton;
        return this;
    }

    public AbstractNotificationStyle withNotificationWindowCreator(ICreateNotificationWindow windowCreator) {
        this.fWindowCreator = windowCreator;
        return this;
    }

    public AbstractNotificationStyle withCustomParams(Map<String, Object> customParams) {
        this.fCustomParams = customParams;
        return this;
    }

    @Override
    public int getWidth() {
        return this.fWindowWidth;
    }

    @Override
    public int getWindowCornerRadius() {
        return this.fWindowCornerRadius;
    }

    @Override
    public Insets getWindowInsets() {
        return (Insets)this.fWindowInsets.clone();
    }

    @Override
    public Font getTitleFont() {
        return this.fTitleFont;
    }

    @Override
    public Font getMessageFont() {
        return this.fMessageFont;
    }

    @Override
    public float getAlpha() {
        return this.fAlpha;
    }

    @Override
    public IBackground getBackground() {
        return this.fBackground;
    }

    @Override
    public Color getTitleFontColor() {
        return this.fTitleFontColor;
    }

    @Override
    public Color getMessageFontColor() {
        return this.fMessageFontColor;
    }

    @Override
    public IOverlay getOverlay() {
        return this.fOverlay;
    }

    @Override
    public ICloseButton getCloseButton() {
        return this.fCloseButton;
    }

    @Override
    public ICreateNotificationWindow getNotificationWindowCreator() {
        return this.fWindowCreator;
    }

    @Override
    public Map<String, Object> getCustomParams() {
        return this.fCustomParams;
    }
}

