/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle;

import ch.swingfx.awt.GraphicsEnvironmentUtil;
import ch.swingfx.timer.AnimationTimer;
import ch.swingfx.twinkle.event.INotificationEventListener;
import ch.swingfx.twinkle.event.NotificationEvent;
import ch.swingfx.twinkle.event.NotificationEventAdapter;
import ch.swingfx.twinkle.manager.INotificationManager;
import ch.swingfx.twinkle.manager.NotificationManagers;
import ch.swingfx.twinkle.style.INotificationStyle;
import ch.swingfx.twinkle.window.GlassPane;
import ch.swingfx.twinkle.window.IPosition;
import ch.swingfx.twinkle.window.Positions;
import ch.swingfx.window.translucentandshaped.ITranslucentAndShapedWindowApi;
import ch.swingfx.window.translucentandshaped.Translucency;
import ch.swingfx.window.translucentandshaped.TranslucentAndShapedWindowApiFactory;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class NotificationBuilder {
    private static final int version = 100;
    private static final int ANIMATION_FADE_IN_DURATION = 800;
    private static final int ANIMATION_FADE_OUT_DURATION = 200;
    private static final int ANIMATION_FADE_IN_START_DELAY = 200;
    private static final int DEFAULT_DISPLAY_TIME_IN_MILLIS = 5000;
    private final UUID fId;
    private Icon fIcon;
    private String fTitle;
    private String fMessage;
    private int fDisplayTime = 5000;
    private INotificationEventListener fNotificationListener = new NotificationEventAdapter(){};
    private INotificationStyle fStyle;
    private IPosition fPosition = Positions.NORTH_EAST;
    private boolean fFadeIn = true;
    private boolean fFadeOut = true;
    private boolean fWindowClosed = false;
    private INotificationManager fManager;
    private static final ITranslucentAndShapedWindowApi sWindowApi;
    private static final GraphicsDevice sMainScreen;
    private static final GraphicsConfiguration sMainScreenGraphicsConfiguration;
    private static final Dimension sMainScreenSize;
    private static Insets sMainScreenInsets;
    private static final Toolkit sToolkit;

    public NotificationBuilder() {
        this.fId = UUID.randomUUID();
        this.fManager = NotificationManagers.SEQUENTIAL;
    }

    public NotificationBuilder withStyle(INotificationStyle style) {
        this.fStyle = style;
        return this;
    }

    public NotificationBuilder withIcon(String iconPath) {
        return this.withIcon(new ImageIcon(iconPath));
    }

    public NotificationBuilder withIcon(Icon icon) {
        this.fIcon = icon;
        return this;
    }

    public NotificationBuilder withTitle(String title) {
        if ("".equals(title)) {
            title = null;
        }
        this.fTitle = title;
        return this;
    }

    public NotificationBuilder withMessage(String message) {
        if ("".equals(message)) {
            message = null;
        }
        this.fMessage = message;
        return this;
    }

    public NotificationBuilder withDisplayTime(int timeInMillis) {
        if (timeInMillis < 1000) {
            timeInMillis = 1000;
        }
        this.fDisplayTime = timeInMillis;
        return this;
    }

    public NotificationBuilder withPosition(IPosition position) {
        this.fPosition = position;
        return this;
    }

    public NotificationBuilder withFadeInAnimation(boolean animate) {
        this.fFadeIn = animate;
        return this;
    }

    public NotificationBuilder withFadeOutAnimation(boolean animate) {
        this.fFadeOut = animate;
        return this;
    }

    public NotificationBuilder withListener(INotificationEventListener listener) {
        this.fNotificationListener = listener;
        return this;
    }

    public NotificationBuilder withNotificationManager(INotificationManager manager) {
        this.fManager = manager;
        return this;
    }

    public INotificationStyle getStyle() {
        return this.fStyle;
    }

    public UUID showNotification() {
        if (this.fStyle == null) {
            throw new IllegalStateException("Please set a style with \"withStyle()\"");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotificationBuilder.this.showNotificationEDT();
            }
        });
        return this.fId;
    }

    private void showNotificationEDT() {
        final Timer closeWindowTimer = new Timer(this.fDisplayTime, null);
        final AnimationTimer fadeInAnimationTimer = new AnimationTimer(AnimationTimer.FrameRate.FPS_25);
        final JWindow window = this.fStyle.getNotificationWindowCreator().createNotificationWindow(this.fIcon, this.fTitle, this.fMessage, this.fStyle, sMainScreenGraphicsConfiguration);
        Point windowPosition = this.fPosition.getPosition(sMainScreenSize, sMainScreenInsets, window, this.fStyle);
        final int x = windowPosition.x;
        final int y = windowPosition.y;
        window.setLocation(x, y);
        final Dimension windowSize = window.getBounds().getSize();
        if (this.fFadeIn && sWindowApi.isTranslucencySupported(Translucency.TRANSLUCENT, sMainScreen)) {
            window.setSize(0, 0);
        }
        closeWindowTimer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (NotificationBuilder.this.fWindowClosed) {
                    return;
                }
                closeWindowTimer.stop();
                NotificationBuilder.this.closeWindow(window);
                NotificationBuilder.this.fNotificationListener.closed(new NotificationEvent(NotificationBuilder.this, NotificationBuilder.this.fId));
            }
        });
        int cornerRadius = 0;
        if (sWindowApi.isTranslucencySupported(Translucency.PERPIXEL_TRANSLUCENT, sMainScreen) && sWindowApi.isTranslucencyCapable(window.getGraphicsConfiguration())) {
            cornerRadius = this.fStyle.getWindowCornerRadius();
        }
        final GlassPane glassPane = new GlassPane(window, this.fStyle, cornerRadius);
        glassPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (NotificationBuilder.this.fWindowClosed) {
                    return;
                }
                fadeInAnimationTimer.stop();
                boolean mouseOverCloseButton = NotificationBuilder.this.fStyle.getCloseButton().isMouseOverCloseButton(window.getMousePosition());
                if (!mouseOverCloseButton) {
                    NotificationBuilder.this.fNotificationListener.clicked(new NotificationEvent(NotificationBuilder.this, NotificationBuilder.this.fId));
                }
                NotificationBuilder.this.closeWindow(window);
                if (mouseOverCloseButton) {
                    NotificationBuilder.this.fNotificationListener.closed(new NotificationEvent(NotificationBuilder.this, NotificationBuilder.this.fId));
                }
            }

            public void mouseEntered(MouseEvent event) {
                if (NotificationBuilder.this.fWindowClosed) {
                    return;
                }
                fadeInAnimationTimer.stop();
                closeWindowTimer.stop();
                NotificationBuilder.this.fNotificationListener.mouseOver(new NotificationEvent(NotificationBuilder.this, NotificationBuilder.this.fId));
                glassPane.repaint();
            }

            public void mouseExited(MouseEvent event) {
                if (NotificationBuilder.this.fWindowClosed) {
                    return;
                }
                closeWindowTimer.start();
                NotificationBuilder.this.fNotificationListener.mouseOut(new NotificationEvent(NotificationBuilder.this, NotificationBuilder.this.fId));
                glassPane.repaint();
            }
        });
        glassPane.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent event) {
                if (NotificationBuilder.this.fWindowClosed) {
                    return;
                }
                boolean mouseOverCloseButton = NotificationBuilder.this.fStyle.getCloseButton().isMouseOverCloseButton(window.getMousePosition());
                if (mouseOverCloseButton) {
                    glassPane.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    glassPane.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        window.setAlwaysOnTop(true);
        window.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                if (e.getID() == 200) {
                    if (NotificationBuilder.this.fStyle.getAlpha() < 1.0f && sWindowApi.isTranslucencySupported(Translucency.PERPIXEL_TRANSLUCENT, sMainScreen) && sWindowApi.isTranslucencyCapable(window.getGraphicsConfiguration())) {
                        sWindowApi.setWindowOpaque((Window)window, false);
                    }
                    if (NotificationBuilder.this.fFadeIn && sWindowApi.isTranslucencySupported(Translucency.TRANSLUCENT, sMainScreen)) {
                        fadeInAnimationTimer.setDuration(800L);
                        fadeInAnimationTimer.setAnimationTarget(new AnimationTimer.AnimationTarget(){

                            public void event(AnimationTimer timer, float fraction) {
                                sWindowApi.setWindowOpacity((Window)window, fraction);
                            }

                            public void end(AnimationTimer timer) {
                                sWindowApi.setWindowOpacity((Window)window, 1.0f);
                            }

                            public void begin(AnimationTimer timer) {
                                window.setSize(windowSize);
                            }
                        });
                        sWindowApi.setWindowOpacity((Window)window, 0.0f);
                        new Timer(200, new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                Timer t = (Timer)e.getSource();
                                t.stop();
                                fadeInAnimationTimer.start();
                            }
                        }).start();
                    }
                    NotificationBuilder.this.fNotificationListener.opened(new NotificationEvent(NotificationBuilder.this, NotificationBuilder.this.fId));
                    Rectangle windowRect = new Rectangle(windowSize.width, windowSize.height);
                    windowRect.setLocation(x, y);
                    if (!windowRect.contains(MouseInfo.getPointerInfo().getLocation())) {
                        closeWindowTimer.start();
                    }
                }
            }
        });
        this.fManager.showNotification(window);
    }

    private void closeWindow(final JWindow window) {
        this.fWindowClosed = true;
        if (this.fFadeOut && sWindowApi.isTranslucencySupported(Translucency.TRANSLUCENT, sMainScreen)) {
            AnimationTimer animationTimer = new AnimationTimer(AnimationTimer.FrameRate.FPS_25);
            animationTimer.setDuration(200L);
            animationTimer.setAnimationTarget(new AnimationTimer.AnimationTarget(){

                public void event(AnimationTimer timer, float fraction) {
                    sWindowApi.setWindowOpacity((Window)window, 1.0f - fraction);
                }

                public void end(AnimationTimer timer) {
                    window.dispose();
                }

                public void begin(AnimationTimer timer) {
                }
            });
            animationTimer.start();
        } else {
            window.dispose();
        }
    }

    static {
        sMainScreen = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        sMainScreenGraphicsConfiguration = sMainScreen.getDefaultConfiguration();
        sToolkit = Toolkit.getDefaultToolkit();
        sMainScreenSize = sToolkit.getScreenSize();
        sWindowApi = TranslucentAndShapedWindowApiFactory.getApi();
        boolean isX11 = GraphicsEnvironmentUtil.isX11GraphicsEnvironment;
        boolean isOSX = GraphicsEnvironmentUtil.isCGraphicsEnvironment;
        if (isX11) {
            Rectangle x11RootNetWorkarea = GraphicsEnvironmentUtil.getX11RootNetWorkarea();
            sMainScreenInsets = x11RootNetWorkarea != null ? new Insets(x11RootNetWorkarea.x, x11RootNetWorkarea.y, NotificationBuilder.sMainScreenSize.height - x11RootNetWorkarea.height, NotificationBuilder.sMainScreenSize.width - x11RootNetWorkarea.width) : sToolkit.getScreenInsets(sMainScreenGraphicsConfiguration);
        } else if (isOSX) {
            sMainScreenInsets = sToolkit.getScreenInsets(sMainScreenGraphicsConfiguration);
            if (sMainScreenInsets == null || NotificationBuilder.sMainScreenInsets.top == 0) {
                sMainScreenInsets = GraphicsEnvironmentUtil.OSX_MENU_BAR_SCREEN_INSETS;
            }
        } else {
            sMainScreenInsets = sToolkit.getScreenInsets(sMainScreenGraphicsConfiguration);
        }
    }
}

