/*
 * Decompiled with CFR 0.152.
 */
package net.java.fishfarm.ui;

import griffon.util.GriffonApplicationUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JPopupTrayIcon
extends TrayIcon {
    private JPopupMenu menu;
    private Window window;
    private PopupMenuListener popupListener;

    public JPopupTrayIcon(Image image) {
        super(image);
        this.init();
    }

    public JPopupTrayIcon(Image image, String tooltip) {
        super(image, tooltip);
        this.init();
    }

    public JPopupTrayIcon(Image image, String tooltip, PopupMenu popup) {
        super(image, tooltip, popup);
        this.init();
    }

    public JPopupTrayIcon(Image image, String tooltip, JPopupMenu popup) {
        super(image, tooltip);
        this.init();
        this.setJPopupMenu(popup);
    }

    private final void init() {
        this.popupListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (JPopupTrayIcon.this.window != null) {
                    JPopupTrayIcon.this.window.dispose();
                    JPopupTrayIcon.this.window = null;
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (JPopupTrayIcon.this.window != null) {
                    JPopupTrayIcon.this.window.dispose();
                    JPopupTrayIcon.this.window = null;
                }
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupTrayIcon.this.showJPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JPopupTrayIcon.this.showJPopupMenu(e);
            }
        });
    }

    private void showJPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger() && this.menu != null && this.window == null) {
            int y;
            if (GriffonApplicationUtils.isWindows()) {
                this.window = new JDialog((Frame)null);
                ((JDialog)this.window).setUndecorated(true);
            } else {
                this.window = new JWindow((Frame)null);
            }
            this.window.setAlwaysOnTop(true);
            Dimension size = this.menu.getPreferredSize();
            Point centerPoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            int x = GriffonApplicationUtils.isMacOSX() ? e.getXOnScreen() : e.getX();
            int n = y = GriffonApplicationUtils.isMacOSX() ? this.getSize().height : e.getY();
            if ((double)y > centerPoint.getY()) {
                this.window.setLocation(x, y - size.height);
            } else {
                this.window.setLocation(x, y);
            }
            this.window.setVisible(true);
            this.menu.show(((RootPaneContainer)((Object)this.window)).getContentPane(), 0, 0);
            this.window.toFront();
        }
    }

    public final JPopupMenu getJPopupMenu() {
        return this.menu;
    }

    public final void setJPopupMenu(JPopupMenu menu) {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(this.popupListener);
        }
        this.menu = menu;
        menu.addPopupMenuListener(this.popupListener);
    }
}

