/*
 * Decompiled with CFR 0.152.
 */
package com.bric.math;

import java.util.Arrays;
import java.util.Comparator;

public class Equations {
    public static boolean VERBOSE_EXCEPTIONS = true;
    private static Comparator coefficientComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            int n;
            int n2 = 0;
            int n3 = 0;
            double[] dArray = (double[])object;
            double[] dArray2 = (double[])object2;
            for (n = 0; n < dArray.length; ++n) {
                if (dArray[n] != 1.0) continue;
                n2 = n;
                n = dArray.length;
            }
            for (n = 0; n < dArray2.length; ++n) {
                if (dArray2[n] != 1.0) continue;
                n3 = n;
                n = dArray2.length;
            }
            return n2 - n3;
        }
    };

    public static String toString(double[][] dArray) {
        String string = "";
        for (int i = 0; i < dArray.length; ++i) {
            string = string + Equations.toString(dArray[i]) + "\n";
        }
        return string.trim();
    }

    public static String toString(double[] dArray) {
        String string = "[";
        for (int i = 0; i < dArray.length; ++i) {
            string = i == 0 ? string + " " + dArray[i] : string + ", " + dArray[i];
        }
        return string + " ]";
    }

    public static void solve(double[][] dArray) {
        Equations.solve(dArray, true);
    }

    public static void solve(double[][] dArray, boolean bl) {
        int n;
        int n2;
        double d;
        if (dArray == null) {
            throw new NullPointerException("The coefficients matrix is null.");
        }
        int n3 = dArray.length;
        boolean[] blArray = new boolean[dArray.length];
        int[] nArray = new int[blArray.length];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < blArray.length) {
            if (dArray[n5].length != n3 + 1) {
                throw new IllegalArgumentException("The matrix must be N x (N+1) units long.  The matrix provided is " + n3 + " x " + dArray[n5].length + " units.");
            }
            if (!blArray[n5] && Math.abs(dArray[n5][n4]) > 1.0E-8) {
                n6 = 0;
                d = 1.0 / dArray[n5][n4];
                n2 = 0;
                while (n2 < dArray[n5].length) {
                    double[] dArray2 = dArray[n5];
                    int n7 = n2++;
                    dArray2[n7] = dArray2[n7] * d;
                }
                dArray[n5][n4] = 1.0;
                blArray[n5] = true;
                for (n2 = 0; n2 < dArray.length; ++n2) {
                    if (blArray[n2]) continue;
                    d = dArray[n2][n4];
                    for (n = 0; n < dArray[n2].length; ++n) {
                        double[] dArray3 = dArray[n2];
                        int n8 = n;
                        dArray3[n8] = dArray3[n8] - dArray[n5][n] * d;
                    }
                }
                nArray[n4++] = n5;
            }
            ++n5;
            n5 %= dArray.length;
            if (++n6 <= dArray.length) continue;
            if (VERBOSE_EXCEPTIONS) {
                throw new IllegalArgumentException("The coefficient matrix cannot be solved.  Either it has infinitely many solutions, or zero solutions:\n" + Equations.toString(dArray));
            }
            throw new IllegalArgumentException("The coefficient matrix cannot be solved.  Either it has infinitely many solutions, or zero solutions.");
        }
        n4 = 0;
        for (n2 = nArray.length - 2; n2 >= 0; --n2) {
            n5 = nArray[n2];
            for (n = dArray[n5].length - 2; n > n2; --n) {
                d = dArray[n5][n] * dArray[nArray[n]][dArray[n5].length - 1];
                double[] dArray4 = dArray[n5];
                int n9 = dArray[n5].length - 1;
                dArray4[n9] = dArray4[n9] - d;
                dArray[n5][n] = 0.0;
            }
        }
        if (bl) {
            Arrays.sort(dArray, coefficientComparator);
        }
    }
}

