/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;

public class PivotTransition2D
extends Transition2D {
    boolean in;
    int type;

    public PivotTransition2D() {
        this(14, true);
    }

    public PivotTransition2D(int n, boolean bl) {
        if (n != 14 && n != 15 && n != 16 && n != 17) {
            throw new IllegalArgumentException("Type must be TOP_LEFT, TOP_RIGHT, BOTTOM_LEFT or BOTTOM_RIGHT");
        }
        this.type = n;
        this.in = bl;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        if (this.in) {
            AffineTransform affineTransform = this.type == 14 ? AffineTransform.getRotateInstance((float)((double)(-(1.0f - f)) * Math.PI / 2.0), 0.0, 0.0) : (this.type == 15 ? AffineTransform.getRotateInstance((float)((double)(1.0f - f) * Math.PI / 2.0), dimension.width, 0.0) : (this.type == 16 ? AffineTransform.getRotateInstance((float)((double)(1.0f - f) * Math.PI / 2.0), 0.0, dimension.height) : AffineTransform.getRotateInstance((float)((double)(1.0f - f) * Math.PI / 2.0), dimension.width, dimension.height)));
            return new Transition2DInstruction[]{new ImageInstruction(true), new ImageInstruction(false, affineTransform, null)};
        }
        AffineTransform affineTransform = this.type == 14 ? AffineTransform.getRotateInstance((float)((double)f * Math.PI / 2.0), 0.0, 0.0) : (this.type == 15 ? AffineTransform.getRotateInstance((float)((double)(-f) * Math.PI / 2.0), dimension.width, 0.0) : (this.type == 16 ? AffineTransform.getRotateInstance((float)((double)(-f) * Math.PI / 2.0), 0.0, dimension.height) : AffineTransform.getRotateInstance((float)((double)(-f) * Math.PI / 2.0), dimension.width, dimension.height)));
        return new Transition2DInstruction[]{new ImageInstruction(false), new ImageInstruction(true, affineTransform, null)};
    }

    public String toString() {
        String string = this.in ? "Pivot In " : "Pivot Out ";
        if (this.type == 14) {
            return string + "Top Left";
        }
        if (this.type == 15) {
            return string + "Top Right";
        }
        if (this.type == 16) {
            return string + "Bottom Left";
        }
        return string + "Bottom Right";
    }
}

