/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.geom.TransformUtils;
import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class CheckerboardTransition2D
extends Transition2D {
    int type;
    int rowCount = 20;
    int columnCount = 20;

    public CheckerboardTransition2D() {
        this(1);
    }

    public CheckerboardTransition2D(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("The type must be RIGHT, LEFT, UP or DOWN.");
        }
        this.type = n;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        GeneralPath generalPath = new GeneralPath();
        if (this.type == 1 || this.type == 2) {
            float f2 = (float)dimension.width / (float)this.columnCount * 2.0f;
            float f3 = (float)dimension.height / (float)this.rowCount;
            for (int i = 0; i < this.rowCount; ++i) {
                float f4 = 0.0f;
                if (i % 2 == 0) {
                    f4 = f2 / 2.0f;
                }
                for (int j = -1; j < this.columnCount; ++j) {
                    generalPath.moveTo((float)j * f2 + f4, (float)i * f3);
                    generalPath.lineTo((float)j * f2 + f4, (float)i * f3 + f3);
                    generalPath.lineTo((float)j * f2 + f2 * f + f4, (float)i * f3 + f3);
                    generalPath.lineTo((float)j * f2 + f2 * f + f4, (float)i * f3);
                    generalPath.lineTo((float)j * f2 + f4, (float)i * f3);
                    generalPath.closePath();
                }
            }
            if (this.type == 2) {
                AffineTransform affineTransform = TransformUtils.createAffineTransform(0.0, 0.0, dimension.width, 0.0, 0.0, dimension.height, dimension.width, 0.0, 0.0, 0.0, dimension.width, dimension.height);
                generalPath.transform(affineTransform);
            }
        } else {
            float f5 = (float)dimension.height / (float)this.rowCount * 2.0f;
            float f6 = (float)dimension.width / (float)this.columnCount;
            for (int i = 0; i < this.columnCount; ++i) {
                float f7 = 0.0f;
                if (i % 2 == 0) {
                    f7 = f5 / 2.0f;
                }
                for (int j = -1; j < this.rowCount; ++j) {
                    generalPath.moveTo((float)i * f6, (float)j * f5 + f7);
                    generalPath.lineTo((float)i * f6 + f6, (float)j * f5 + f7);
                    generalPath.lineTo((float)i * f6 + f6, (float)j * f5 + f5 * f + f7);
                    generalPath.lineTo((float)i * f6, (float)j * f5 + f5 * f + f7);
                    generalPath.lineTo((float)i * f6, (float)j * f5 + f7);
                    generalPath.closePath();
                }
            }
            if (this.type == 3) {
                AffineTransform affineTransform = TransformUtils.createAffineTransform(0.0, 0.0, dimension.width, 0.0, 0.0, dimension.height, 0.0, dimension.height, dimension.width, dimension.height, 0.0, 0.0);
                generalPath.transform(affineTransform);
            }
        }
        return new Transition2DInstruction[]{new ImageInstruction(true), new ImageInstruction(false, null, generalPath)};
    }

    public String toString() {
        if (this.type == 1) {
            return "Checkerboard Right";
        }
        if (this.type == 2) {
            return "Checkerboard Left";
        }
        if (this.type == 3) {
            return "Checkerboard Up";
        }
        return "Checkerboard Down";
    }
}

