/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class BlindsTransition2D
extends Transition2D {
    int type;
    int blinds;

    public BlindsTransition2D() {
        this(1);
    }

    public BlindsTransition2D(int n) {
        this(n, 10);
    }

    public BlindsTransition2D(int n, int n2) {
        if (n != 2 && n != 1 && n != 3 && n != 4) {
            throw new IllegalArgumentException("The type must be LEFT, RIGHT, UP or DOWN");
        }
        if (n2 < 4) {
            throw new IllegalArgumentException("The number of blinds (" + n2 + ") must be greater than 3.");
        }
        this.type = n;
        this.blinds = n2;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        Vector<ImageInstruction> vector = new Vector<ImageInstruction>();
        vector.add(new ImageInstruction(this.type == 1 || this.type == 4));
        float f2 = this.type == 2 || this.type == 1 ? (float)dimension.width / (float)this.blinds : (float)dimension.height / (float)this.blinds;
        for (int i = 0; i < this.blinds; ++i) {
            Rectangle2D.Float float_ = this.type == 4 ? new Rectangle2D.Float(0.0f, (float)i * f2, dimension.width, f * f2) : (this.type == 3 ? new Rectangle2D.Float(0.0f, (float)i * f2, dimension.width, f2 - f * f2) : (this.type == 1 ? new Rectangle2D.Float((float)i * f2, 0.0f, f * f2, dimension.height) : new Rectangle2D.Float((float)i * f2, 0.0f, f2 - f * f2, dimension.height)));
            vector.add(new ImageInstruction(this.type == 3 || this.type == 2, null, float_));
        }
        return vector.toArray(new Transition2DInstruction[vector.size()]);
    }

    public String toString() {
        if (this.type == 2) {
            return "Blinds Left";
        }
        if (this.type == 1) {
            return "Blinds Right";
        }
        if (this.type == 3) {
            return "Blinds Up";
        }
        return "Blinds Down";
    }
}

