/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Random;
import java.util.Vector;

public class BarsTransition2D
extends Transition2D {
    static Random random = new Random(System.currentTimeMillis());
    int type;
    boolean isRandom;

    public BarsTransition2D() {
        this(9, true);
    }

    public BarsTransition2D(int n, boolean bl) {
        if (n != 9 && n != 10) {
            throw new IllegalArgumentException("Type must be HORIZONTAL or VERTICAL.");
        }
        this.type = n;
        this.isRandom = bl;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        boolean[] blArray = this.type == 9 ? new boolean[dimension.height] : new boolean[dimension.width];
        Random random = this.isRandom ? BarsTransition2D.random : new Random(0L);
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = random.nextFloat() > f;
        }
        Vector<ImageInstruction> vector = new Vector<ImageInstruction>();
        vector.add(new ImageInstruction(false));
        if (this.type == 9) {
            for (int i = 0; i < blArray.length; ++i) {
                int n = 0;
                while (i + n < blArray.length && blArray[i + n]) {
                    ++n;
                }
                if (n == 0) continue;
                Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, i, dimension.width, n);
                vector.add(new ImageInstruction(true, null, float_));
                i += n;
            }
        } else {
            for (int i = 0; i < blArray.length; ++i) {
                int n = 0;
                while (i + n < blArray.length && blArray[i + n]) {
                    ++n;
                }
                if (n == 0) continue;
                Rectangle2D.Float float_ = new Rectangle2D.Float(i, 0.0f, n, dimension.height);
                vector.add(new ImageInstruction(true, null, float_));
                i += n;
            }
        }
        return vector.toArray(new Transition2DInstruction[vector.size()]);
    }

    public String toString() {
        if (this.type == 9) {
            if (this.isRandom) {
                return "Bars Horizontal Random";
            }
            return "Bars Horizontal";
        }
        if (this.isRandom) {
            return "Bars Vertical Random";
        }
        return "Bars Vertical";
    }
}

