/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.geom.ShapeBounds;
import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;

public abstract class AbstractShapeTransition2D
extends Transition2D {
    int type;
    Hashtable multipliers = new Hashtable();

    public AbstractShapeTransition2D() {
        this(8);
    }

    public AbstractShapeTransition2D(int n) {
        if (n != 7 && n != 8) {
            throw new IllegalArgumentException("Type must be IN or OUT.");
        }
        this.type = n;
    }

    public abstract Shape getShape();

    protected float calculateMultiplier(Dimension dimension) {
        Shape shape = this.getShape();
        Area area = new Area(shape);
        AffineTransform affineTransform = new AffineTransform();
        Rectangle2D rectangle2D = ShapeBounds.getBounds(area);
        affineTransform.translate((double)((float)dimension.width / 2.0f) - rectangle2D.getCenterX(), (double)((float)dimension.height / 2.0f) - rectangle2D.getCenterY());
        area.transform(affineTransform);
        rectangle2D = ShapeBounds.getBounds((Shape)area, rectangle2D);
        float f = 0.0f;
        float f2 = 1.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height);
        while (!this.isOK(area, rectangle2D, float_, f2)) {
            f = f2;
            f2 = (float)((double)f2 * 1.2);
        }
        float f3 = this.calculateMultiplier(area, rectangle2D, float_, f, f2);
        this.isOK(area, rectangle2D, float_, f3);
        return f3;
    }

    private float calculateMultiplier(Area area, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, float f, float f2) {
        if ((double)(f2 - f) < 0.5) {
            return f2;
        }
        float f3 = (f + f2) / 2.0f;
        if (this.isOK(area, rectangle2D, rectangle2D2, f3)) {
            return this.calculateMultiplier(area, rectangle2D, rectangle2D2, f, f3);
        }
        return this.calculateMultiplier(area, rectangle2D, rectangle2D2, f3, f2);
    }

    private boolean isOK(Area area, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, float f) {
        Area area2 = new Area(area);
        area2.transform(AffineTransform.getScaleInstance(f, f));
        Rectangle2D rectangle2D3 = ShapeBounds.getBounds(area2);
        area2.transform(AffineTransform.getTranslateInstance(-rectangle2D3.getCenterX() + rectangle2D2.getCenterX(), -rectangle2D3.getCenterY() + rectangle2D2.getCenterY()));
        Area area3 = new Area(rectangle2D2);
        area3.subtract(area2);
        return area3.isEmpty();
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        Number number = (Number)this.multipliers.get(dimension);
        if (number == null) {
            number = new Float(this.calculateMultiplier(dimension));
            this.multipliers.put(dimension, number);
        }
        if (this.type == 7) {
            f = 1.0f - f;
        }
        Shape shape = this.getShape();
        Rectangle2D rectangle2D = ShapeBounds.getBounds(shape);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToIdentity();
        affineTransform.translate(dimension.width / 2, dimension.height / 2);
        affineTransform.scale(f * number.floatValue(), f * number.floatValue());
        affineTransform.translate(-dimension.width / 2, -dimension.height / 2);
        affineTransform.translate(-rectangle2D.getCenterX() + (double)((float)dimension.width / 2.0f), -rectangle2D.getCenterY() + (double)((float)dimension.height / 2.0f));
        shape = affineTransform.createTransformedShape(shape);
        return new Transition2DInstruction[]{new ImageInstruction(this.type == 8), new ImageInstruction(this.type != 8, null, shape)};
    }

    public abstract String getShapeName();

    public String toString() {
        if (this.type == 7) {
            return this.getShapeName() + " In";
        }
        return this.getShapeName() + " Out";
    }
}

