/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.spunk;

import com.bric.geom.TransformUtils;
import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class SquaresTransition2D
extends Transition2D {
    Comparator comparator = new Comparator(){

        public int compare(Object object, Object object2) {
            double d;
            ImageInstruction imageInstruction = (ImageInstruction)object;
            ImageInstruction imageInstruction2 = (ImageInstruction)object2;
            if (imageInstruction.isFirstFrame && !imageInstruction2.isFirstFrame) {
                return 1;
            }
            if (imageInstruction2.isFirstFrame && !imageInstruction.isFirstFrame) {
                return -1;
            }
            double d2 = imageInstruction.transform.getDeterminant();
            if (d2 < (d = imageInstruction2.transform.getDeterminant())) {
                return -1;
            }
            return 1;
        }
    };
    float[][] accels;
    float[][] delays;
    float progressMax = 1.0f;

    public SquaresTransition2D() {
        this(10, 10);
    }

    public SquaresTransition2D(int n, int n2) {
        this.delays = new float[n][n2];
        this.accels = new float[n][n2];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f = (j - n2 / 2) * (j - n2 / 2) + (i - n / 2) * (i - n / 2);
                this.delays[i][j] = 0.3f * (f /= (float)(n2 * n2 / 4 + n * n / 4)) + 0.1f * random.nextFloat();
                this.accels[i][j] = 0.5f + 0.8f * random.nextFloat();
            }
        }
        this.progressMax = this.findMax(0.0f, 2.0f);
    }

    protected float findMax(float f, float f2) {
        if ((double)(f2 - f) < 1.0E-4) {
            return Math.max(f, f2);
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 100.0f, 100.0f);
        float f3 = f / 2.0f + f2 / 2.0f;
        Transition2DInstruction[] transition2DInstructionArray = this.getInstructions(f, new Dimension(100, 100));
        Transition2DInstruction[] transition2DInstructionArray2 = this.getInstructions(f3, new Dimension(100, 100));
        Transition2DInstruction[] transition2DInstructionArray3 = this.getInstructions(f2, new Dimension(100, 100));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 1; i < transition2DInstructionArray.length; ++i) {
            if (float_.intersects((Rectangle2D)((ImageInstruction)transition2DInstructionArray[i]).clipping)) {
                bl = true;
            }
            if (float_.intersects((Rectangle2D)((ImageInstruction)transition2DInstructionArray2[i]).clipping)) {
                bl2 = true;
            }
            if (!float_.intersects((Rectangle2D)((ImageInstruction)transition2DInstructionArray3[i]).clipping)) continue;
            bl3 = true;
        }
        if (bl && bl3) {
            return Math.max(f, f2);
        }
        if (bl) {
            if (bl2) {
                return this.findMax(f3, f2);
            }
            return this.findMax(f, f3);
        }
        throw new RuntimeException();
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        f *= this.progressMax;
        int n = this.accels.length;
        int n2 = this.accels[0].length;
        Transition2DInstruction[] transition2DInstructionArray = new ImageInstruction[n * n2 + 1];
        transition2DInstructionArray[0] = new ImageInstruction(false);
        float f2 = (float)dimension.width / (float)n;
        float f3 = (float)dimension.height / (float)n2;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f4 = this.delays[i][j];
                float f5 = this.accels[i][j];
                float f6 = f - f4;
                if (f6 < 0.0f) {
                    f6 = 0.0f;
                }
                float f7 = 1.0f + 120.0f * f5 * f6 * f6;
                Rectangle2D.Float float_ = new Rectangle2D.Float((float)i * f2, (float)j * f3, f2, f3);
                AffineTransform affineTransform = new AffineTransform();
                float f8 = dimension.width / 2;
                float f9 = dimension.height / 2;
                affineTransform.translate(f8, f9);
                affineTransform.scale(f7, f7);
                double d = (double)f8 - float_.getCenterX();
                double d2 = (double)f9 - float_.getCenterY();
                affineTransform.translate((double)(-f8) - (double)(10.0f * f6) * d * (double)f, (double)(-f9) - (double)(10.0f * f6) * d2 * (double)f);
                Rectangle2D rectangle2D = TransformUtils.transform(affineTransform, float_);
                transition2DInstructionArray[1 + n3++] = new ImageInstruction(true, affineTransform, rectangle2D);
            }
        }
        Arrays.sort(transition2DInstructionArray, this.comparator);
        return transition2DInstructionArray;
    }

    public String toString() {
        return "Squares";
    }
}

