/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.spunk;

import com.bric.geom.ShapeStringUtils;
import com.bric.geom.ShapeUtils;
import com.bric.geom.TransformUtils;
import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class SpiralTransition2D
extends Transition2D {
    Shape spiral = ShapeStringUtils.createGeneralPath("m 32.574 32.527 c 21.77 23.645 42.863 21.455 42.537 32.494 c 42.212 43.533 34.209 45.303 27.629 42.58 c 21.049 39.857 17.374 35.943 18.708 27.331 c 20.043 18.72 27.036 7.229 39.603 12.433 c 52.17 17.636 56.668 23.651 53.935 37.469 c 51.202 51.287 43.916 57.222 28.139 53.074 c 12.361 48.927 0.062 39.761 7.31 20.954 c 14.558 2.147 23.188 -2.412 40.942 0.083 c 58.696 2.579 69.57 20.663 64.804 38.565 c 60.038 56.468 53.063 66.173 28.941 64.198 c 4.82 62.224 -7.552 41.196 -6.927 32.645 c -6.303 24.094 -1.187 8.315 6.772 -1.593 z");
    boolean sprawl = true;
    Rectangle2D shapeBounds;

    public SpiralTransition2D(boolean bl) {
        this.sprawl = bl;
        this.shapeBounds = new Rectangle2D.Float(0.0f, 0.0f, 60.0f, 60.0f);
    }

    public String toString() {
        if (this.sprawl) {
            return "Spiral Sprawl";
        }
        return "Spiral";
    }

    public Shape getShape(float f) {
        if (this.sprawl) {
            double d = (double)((1.0f - f) * 3.0f) * Math.PI;
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d, 30.0, 30.0);
            return affineTransform.createTransformedShape(this.spiral);
        }
        return this.spiral;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        Shape shape = ShapeUtils.traceShape(this.getShape(f), f);
        BasicStroke basicStroke = new BasicStroke(16.23f, 1, 1);
        shape = basicStroke.createStrokedShape(shape);
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height);
        AffineTransform affineTransform = TransformUtils.createAffineTransform(this.shapeBounds, float_);
        shape = affineTransform.createTransformedShape(shape);
        return new Transition2DInstruction[]{new ImageInstruction(true), new ImageInstruction(false, null, shape)};
    }
}

