/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.spunk;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.Vector;

public class HalftoneTransition2D
extends Transition2D {
    int type = 8;

    public HalftoneTransition2D() {
    }

    public HalftoneTransition2D(int n) {
        if (n != 7 && n != 8) {
            throw new IllegalArgumentException("The type must be IN or OUT");
        }
        this.type = n;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        int n;
        if (this.type == 8) {
            f = 1.0f - f;
        }
        f = (float)Math.pow(f, 0.5);
        float f2 = (float)dimension.height * 0.05f;
        float f3 = (float)dimension.width * 0.05f;
        Vector<RoundRectangle2D.Double> vector = new Vector<RoundRectangle2D.Double>();
        float f4 = (float)Math.pow(1.0f - Math.min(f, 1.0f), 0.5);
        float f5 = 1.3f * f;
        double d = f3 * f5;
        double d2 = f2 * f5;
        float f6 = (float)Math.min(d, d2);
        for (float f7 = 0.0f; f7 < (float)dimension.height; f7 += f2) {
            for (float f8 = 0.0f; f8 < (float)dimension.width; f8 += f3) {
                vector.add(new RoundRectangle2D.Double((double)(f8 + f3 / 2.0f) - d / 2.0, (double)(f7 + f2 / 2.0f) - d2 / 2.0, d * (double)f + (double)((1.0f - f) * f6), d2 * (double)f + (double)((1.0f - f) * f6), d * (double)f4 * (double)f + (double)((1.0f - f) * f6 * f4), d2 * (double)f4 * (double)f + (double)((1.0f - f) * f6 * f4)));
            }
        }
        Transition2DInstruction[] transition2DInstructionArray = new ImageInstruction[vector.size() + 1];
        transition2DInstructionArray[0] = new ImageInstruction(false);
        for (n = 0; n < vector.size(); ++n) {
            float f9 = f;
            RectangularShape rectangularShape = (RectangularShape)vector.get(n);
            Point2D.Double double_ = new Point2D.Double(rectangularShape.getCenterX(), rectangularShape.getCenterY());
            Point2D.Double double_2 = new Point2D.Double(rectangularShape.getCenterX(), rectangularShape.getCenterY());
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(rectangularShape.getCenterX(), rectangularShape.getCenterY());
            affineTransform.scale(30.0f * (1.0f - f) + 1.0f, 30.0f * (1.0f - f) + 1.0f);
            affineTransform.translate(-rectangularShape.getCenterX(), -rectangularShape.getCenterY());
            affineTransform.rotate(0.3 * (double)(1.0f - f9), dimension.width / 3, dimension.height / 2);
            affineTransform.transform(double_, double_2);
            affineTransform.setToTranslation(((Point2D)double_).getX() - ((Point2D)double_2).getX(), ((Point2D)double_).getY() - ((Point2D)double_2).getY());
            Shape shape = affineTransform.createTransformedShape(rectangularShape);
            transition2DInstructionArray[n + 1] = new ImageInstruction(true, affineTransform, shape);
        }
        if (this.type == 7) {
            for (n = 0; n < transition2DInstructionArray.length; ++n) {
                ((ImageInstruction)transition2DInstructionArray[n]).isFirstFrame = !((ImageInstruction)transition2DInstructionArray[n]).isFirstFrame;
            }
        }
        return transition2DInstructionArray;
    }

    public String toString() {
        if (this.type == 7) {
            return "Halftone In";
        }
        return "Halftone Out";
    }
}

