/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition;

import com.bric.image.transition.Transition2DInstruction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class ShapeInstruction
extends Transition2DInstruction {
    public Color fillColor;
    public Color strokeColor;
    public float strokeWidth;
    public Shape shape;

    public ShapeInstruction(Shape shape, Color color, Color color2, float f) {
        if (shape == null) {
            throw new NullPointerException("A ShapeInstruction cannot have a null shape.");
        }
        this.fillColor = color;
        this.strokeColor = color2;
        this.strokeWidth = f;
        this.shape = shape;
    }

    public ShapeInstruction(Shape shape, float f) {
        this.shape = new GeneralPath(shape);
        this.fillColor = new Color(0, 0, 0, (int)(255.0f * f));
    }

    public void paint(Graphics2D graphics2D, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Paint paint = graphics2D.getPaint();
        if (this.fillColor != null) {
            graphics2D.setColor(this.fillColor);
            graphics2D.fill(this.shape);
        }
        if (this.strokeColor != null && this.strokeWidth > 0.0f) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(this.strokeWidth));
            graphics2D.setColor(this.strokeColor);
            graphics2D.draw(this.shape);
            graphics2D.setStroke(stroke);
        }
        graphics2D.setPaint(paint);
    }
}

