/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition;

import com.bric.geom.Clipper;
import com.bric.geom.ShapeStringUtils;
import com.bric.geom.TransformUtils;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class ImageInstruction
extends Transition2DInstruction {
    public boolean isFirstFrame = true;
    public Shape clipping = null;
    public AffineTransform transform = null;
    public float opacity = 1.0f;

    public ImageInstruction(boolean bl, float f, AffineTransform affineTransform, Shape shape) {
        this(bl, affineTransform, shape);
        this.opacity = f;
    }

    public ImageInstruction(boolean bl, float f) {
        this(bl);
        this.opacity = f;
    }

    public ImageInstruction(boolean bl, float f, Rectangle2D rectangle2D, Dimension dimension, Shape shape) {
        this(bl, f, TransformUtils.createAffineTransform(new Rectangle2D.Double(0.0, 0.0, dimension.width, dimension.height), rectangle2D), shape);
    }

    public ImageInstruction(boolean bl) {
        this(bl, null, null);
    }

    public String toString() {
        String string = this.clipping == null ? "null" : ShapeStringUtils.toString(this.clipping);
        return "ImageInstruction[ isFirstFrame = " + this.isFirstFrame + ", transform = " + this.transform + ", clipping = " + string + " opacity=" + this.opacity + "]";
    }

    public ImageInstruction(ImageInstruction imageInstruction) {
        this.clipping = imageInstruction.clipping;
        this.isFirstFrame = imageInstruction.isFirstFrame;
        this.transform = imageInstruction.transform;
        this.opacity = imageInstruction.opacity;
    }

    public ImageInstruction(boolean bl, AffineTransform affineTransform, Shape shape) {
        this.isFirstFrame = bl;
        if (affineTransform != null) {
            this.transform = new AffineTransform(affineTransform);
        }
        if (shape != null) {
            if (shape instanceof Rectangle) {
                this.clipping = new Rectangle((Rectangle)shape);
            } else if (shape instanceof Rectangle2D) {
                Rectangle2D.Float float_ = new Rectangle2D.Float();
                float_.setFrame((Rectangle2D)shape);
                this.clipping = float_;
            } else {
                this.clipping = new GeneralPath(shape);
            }
        }
    }

    public ImageInstruction(boolean bl, Rectangle2D rectangle2D, Dimension dimension, Shape shape) {
        this(bl, TransformUtils.createAffineTransform(new Rectangle2D.Double(0.0, 0.0, dimension.width, dimension.height), rectangle2D), shape);
    }

    public void paint(Graphics2D graphics2D, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        BufferedImage bufferedImage3 = this.isFirstFrame ? bufferedImage : bufferedImage2;
        Composite composite = null;
        if (this.opacity != 1.0f) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
        }
        Shape shape = null;
        if (this.clipping != null) {
            shape = graphics2D.getClip();
            Clipper.clip(graphics2D, this.clipping);
        }
        graphics2D.drawImage(bufferedImage3, this.transform, null);
        if (this.clipping != null) {
            graphics2D.setClip(shape);
        }
        if (this.opacity != 1.0f) {
            graphics2D.setComposite(composite);
        }
    }
}

