/*
 * Decompiled with CFR 0.152.
 */
package com.bric.geom;

import java.awt.geom.PathIterator;

class SerializedPathIterator
implements PathIterator {
    char[] c;
    int ctr = 0;
    double[] data = new double[6];
    int currentSegment = -1;
    int windingRule;

    public SerializedPathIterator(String string, int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("The winding rule must be PathIterator.WIND_NON_ZERO or PathIterator.WIND_EVEN_ODD");
        }
        this.c = string.toCharArray();
        this.windingRule = n;
        this.next();
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public void next() {
        int n;
        if (this.ctr == this.c.length + 1) {
            ++this.ctr;
            return;
        }
        if (this.ctr >= this.c.length) {
            throw new IllegalStateException("There are no more segments to iterate to.");
        }
        char c = this.c[this.ctr];
        switch (c) {
            case 'M': 
            case 'm': {
                this.currentSegment = 0;
                n = 2;
                break;
            }
            case 'L': 
            case 'l': {
                this.currentSegment = 1;
                n = 2;
                break;
            }
            case 'Q': 
            case 'q': {
                this.currentSegment = 2;
                n = 4;
                break;
            }
            case 'C': 
            case 'c': {
                this.currentSegment = 3;
                n = 6;
                break;
            }
            case 'Z': 
            case 'z': {
                this.currentSegment = 4;
                n = 0;
                break;
            }
            default: {
                System.err.println("\"" + new String(this.c) + "\"\nctr=" + this.ctr);
                throw new RuntimeException("Unrecognized character in shape data: '" + this.c[this.ctr] + "'");
            }
        }
        this.ctr += 2;
        if (n > 0) {
            this.parse(n);
        }
    }

    private void parse(int n) {
        for (int i = 0; i < n; ++i) {
            this.data[i] = this.parseTerm();
        }
    }

    private double parseTerm() {
        boolean bl = false;
        double d = 0.0;
        char c = this.c[this.ctr];
        if (c == '-') {
            bl = true;
            ++this.ctr;
            c = this.c[this.ctr];
        }
        long l = -1L;
        while (c != ' ' && this.ctr < this.c.length) {
            if (c >= '0' && c <= '9') {
                int n = c - 48;
                d = d * 10.0 + (double)n;
                if (l > 0L) {
                    l *= 10L;
                }
            } else if (c == '.') {
                l = 1L;
            }
            ++this.ctr;
            if (this.ctr >= this.c.length) continue;
            c = this.c[this.ctr];
        }
        if (bl) {
            d = -d;
        }
        ++this.ctr;
        return d /= (double)l;
    }

    public int currentSegment(double[] dArray) {
        dArray[0] = this.data[0];
        dArray[1] = this.data[1];
        dArray[2] = this.data[2];
        dArray[3] = this.data[3];
        dArray[4] = this.data[4];
        dArray[5] = this.data[5];
        return this.currentSegment;
    }

    public int currentSegment(float[] fArray) {
        fArray[0] = (float)this.data[0];
        fArray[1] = (float)this.data[1];
        fArray[2] = (float)this.data[2];
        fArray[3] = (float)this.data[3];
        fArray[4] = (float)this.data[4];
        fArray[5] = (float)this.data[5];
        return this.currentSegment;
    }

    public boolean isDone() {
        return this.ctr > this.c.length + 1;
    }
}

