/*
 * Decompiled with CFR 0.152.
 */
package com.bric.geom;

import com.bric.geom.GeneralPathWriter;
import com.bric.geom.PathWriter;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Vector;

public class MeasuredShape {
    public static final float DEFAULT_SPACING = 0.05f;
    Segment[] segments;
    float totalDistance = 0.0f;
    float originalDistance;

    public static MeasuredShape[] getSubpaths(Shape shape) {
        return MeasuredShape.getSubpaths(shape.getPathIterator(null), 0.05f);
    }

    public static MeasuredShape[] getSubpaths(Shape shape, float f) {
        return MeasuredShape.getSubpaths(shape.getPathIterator(null), f);
    }

    public static MeasuredShape[] getSubpaths(PathIterator pathIterator) {
        return MeasuredShape.getSubpaths(pathIterator, 0.05f);
    }

    public static MeasuredShape[] getSubpaths(PathIterator pathIterator, float f) {
        Vector<MeasuredShape> vector = new Vector<MeasuredShape>();
        GeneralPath generalPath = null;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (n == 0) {
                if (generalPath != null) {
                    vector.add(new MeasuredShape(generalPath, f));
                    generalPath = null;
                }
                generalPath = new GeneralPath();
                generalPath.moveTo(fArray[0], fArray[1]);
            } else if (n == 1) {
                generalPath.lineTo(fArray[0], fArray[1]);
            } else if (n == 2) {
                generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
            } else if (n == 3) {
                generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
            } else if (n == 4) {
                generalPath.closePath();
            }
            pathIterator.next();
        }
        if (generalPath != null) {
            vector.add(new MeasuredShape(generalPath, f));
            generalPath = null;
        }
        return vector.toArray(new MeasuredShape[vector.size()]);
    }

    public MeasuredShape(Shape shape) {
        this(shape.getPathIterator(null), 0.05f);
    }

    public MeasuredShape(Shape shape, float f) {
        this(shape.getPathIterator(null), f);
    }

    public MeasuredShape(PathIterator pathIterator) {
        this(pathIterator, 0.05f);
    }

    public MeasuredShape(PathIterator pathIterator, float f) {
        Segment segment;
        Vector<Segment> vector = new Vector<Segment>();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n = 0;
        boolean bl = false;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            if (n2 == 4) {
                bl = true;
            } else if (n2 == 0) {
                if (n == 1) {
                    throw new IllegalArgumentException("this object can only contain 1 subpath");
                }
                f4 = fArray[0];
                f5 = fArray[1];
                f2 = f4;
                f3 = f5;
                ++n;
            } else if (n2 == 1 || n2 == 2 || n2 == 3) {
                if (n != 1) {
                    throw new IllegalArgumentException("this shape data did not begin with a moveTo");
                }
                segment = new Segment(n2, f2, f3, fArray, f);
                f2 = segment.data[segment.data.length - 2];
                f3 = segment.data[segment.data.length - 1];
                vector.add(segment);
                this.totalDistance += segment.realDistance;
            }
            pathIterator.next();
        }
        float f6 = this.totalDistance;
        if (vector.size() > 0) {
            segment = (Segment)vector.get(vector.size() - 1);
            if ((double)Math.abs(segment.data[segment.data.length - 2] - f4) > 0.001 || (double)Math.abs(segment.data[segment.data.length - 1] - f5) > 0.001) {
                fArray[0] = f4;
                fArray[1] = f5;
                Segment segment2 = new Segment(1, f2, f3, fArray, f);
                vector.add(segment2);
                this.totalDistance += segment2.realDistance;
            }
        }
        this.originalDistance = !bl ? f6 : this.totalDistance;
        this.segments = vector.toArray(new Segment[vector.size()]);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].normalizedDistance = this.segments[i].realDistance / this.totalDistance;
        }
    }

    public void writeShape(PathWriter pathWriter) {
        pathWriter.moveTo(this.segments[0].getX(0.0f), this.segments[0].getY(0.0f));
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].write(pathWriter, 0.0f, 1.0f);
        }
        pathWriter.closePath();
    }

    public float getDistance() {
        return this.totalDistance;
    }

    public float getOriginalDistance() {
        return this.originalDistance;
    }

    public void writeShapeBackwards(PathWriter pathWriter) {
        pathWriter.moveTo(this.segments[this.segments.length - 1].getX(1.0f), this.segments[this.segments.length - 1].getY(1.0f));
        for (int i = this.segments.length - 1; i >= 0; --i) {
            this.segments[i].write(pathWriter, 1.0f, 0.0f);
        }
        pathWriter.closePath();
    }

    public float getMoveToX() {
        Segment segment = this.segments[0];
        return segment.getX(0.0f);
    }

    public float getMoveToY() {
        Segment segment = this.segments[0];
        return segment.getY(0.0f);
    }

    public void writeShape(float f, float f2, PathWriter pathWriter) {
        this.writeShape(f, f2, pathWriter, true);
    }

    public void writeShape(float f, float f2, PathWriter pathWriter, boolean bl) {
        if (f2 >= 0.999999f) {
            this.writeShape(pathWriter);
            return;
        }
        if (f2 <= -0.999999f) {
            this.writeShapeBackwards(pathWriter);
            return;
        }
        if ((double)f2 < 1.0E-6 && (double)f2 > -1.0E-6) {
            return;
        }
        Position position = this.getIndexOfPosition(f);
        Position position2 = this.getIndexOfPosition(f + f2);
        if (bl) {
            pathWriter.moveTo(this.segments[position.i].getX(position.innerPosition), this.segments[position.i].getY(position.innerPosition));
        }
        if (position.i == position2.i && (f2 > 0.0f && position2.innerPosition > position.innerPosition || f2 < 0.0f && position2.innerPosition < position.innerPosition)) {
            this.segments[position.i].write(pathWriter, position.innerPosition, position2.innerPosition);
        } else if (f2 > 0.0f) {
            this.segments[position.i].write(pathWriter, position.innerPosition, 1.0f);
            int n = position.i + 1;
            if (n >= this.segments.length) {
                n = 0;
            }
            while (n != position2.i) {
                this.segments[n].write(pathWriter, 0.0f, 1.0f);
                if (++n < this.segments.length) continue;
                n = 0;
            }
            this.segments[position2.i].write(pathWriter, 0.0f, position2.innerPosition);
        } else {
            this.segments[position.i].write(pathWriter, position.innerPosition, 0.0f);
            int n = position.i - 1;
            if (n < 0) {
                n = this.segments.length - 1;
            }
            while (n != position2.i) {
                this.segments[n].write(pathWriter, 1.0f, 0.0f);
                if (--n >= 0) continue;
                n = this.segments.length - 1;
            }
            this.segments[position2.i].write(pathWriter, 1.0f, position2.innerPosition);
        }
    }

    public Point2D getPoint(float f, Point2D point2D) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("distance (" + f + ") must not be negative");
        }
        if (f > this.totalDistance) {
            throw new IllegalArgumentException("distance (" + f + ") must not be greater than the total distance of this shape (" + this.totalDistance + ")");
        }
        if (point2D == null) {
            point2D = new Point2D.Float();
        }
        for (int i = 0; i < this.segments.length; ++i) {
            float f2 = f / this.segments[i].realDistance;
            if (f2 >= 1.0f) {
                f -= this.segments[i].realDistance;
                continue;
            }
            point2D.setLocation(this.segments[i].getX(f2), this.segments[i].getY(f2));
            return point2D;
        }
        point2D.setLocation(this.segments[0].getX(0.0f), this.segments[0].getY(0.0f));
        return point2D;
    }

    public float getTangentSlope(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("distance (" + f + ") must not be negative");
        }
        if (f > this.totalDistance) {
            throw new IllegalArgumentException("distance (" + f + ") must not be greater than the total distance of this shape (" + this.totalDistance + ")");
        }
        for (int i = 0; i < this.segments.length; ++i) {
            float f2 = f / this.segments[i].realDistance;
            if (f2 >= 1.0f) {
                f -= this.segments[i].realDistance;
                continue;
            }
            return this.segments[i].getTangentSlope(f2);
        }
        return this.segments[0].getTangentSlope(0.0f);
    }

    private static boolean equal(float f, float f2) {
        float f3 = f - f2;
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        return (double)f3 < 1.0E-4;
    }

    public float getCommonDistance(MeasuredShape measuredShape) {
        float f = 0.0f;
        int n = Math.min(this.segments.length, measuredShape.segments.length);
        for (int i = 0; i < n; ++i) {
            if (this.segments[i].type != 0 && measuredShape.segments[i].type != 0) {
                if (MeasuredShape.equal(this.segments[i].data[0], measuredShape.segments[i].data[0]) && MeasuredShape.equal(this.segments[i].data[1], measuredShape.segments[i].data[1]) && MeasuredShape.equal(this.segments[i].data[this.segments[i].data.length - 2], measuredShape.segments[i].data[measuredShape.segments[i].data.length - 2]) && MeasuredShape.equal(this.segments[i].data[this.segments[i].data.length - 1], measuredShape.segments[i].data[measuredShape.segments[i].data.length - 1]) && MeasuredShape.equal(this.segments[i].realDistance, measuredShape.segments[i].realDistance)) {
                    f += this.segments[i].realDistance;
                    continue;
                }
                return f;
            }
            if (this.segments[i].type == 0 && measuredShape.segments[i].type == 0) continue;
            return f;
        }
        return f;
    }

    public GeneralPath getShape(float f, float f2) {
        GeneralPath generalPath = new GeneralPath(1);
        GeneralPathWriter generalPathWriter = new GeneralPathWriter(generalPath);
        this.writeShape(f, f2, generalPathWriter, true);
        return generalPath;
    }

    private Position getIndexOfPosition(float f) {
        while (f < 0.0f) {
            f += 1.0f;
        }
        while (f > 1.0f) {
            f -= 1.0f;
        }
        if (f > 0.99999f) {
            f = 0.0f;
        }
        float f2 = f;
        for (int i = 0; i < this.segments.length; ++i) {
            if (f <= this.segments[i].normalizedDistance && this.segments[i].normalizedDistance != 0.0f) {
                return new Position(i, f / this.segments[i].normalizedDistance);
            }
            f -= this.segments[i].normalizedDistance;
        }
        System.err.println("p = " + f);
        throw new RuntimeException("the position " + f2 + " could not be found.");
    }

    static class Position {
        int i;
        float innerPosition;

        public Position(int n, float f) {
            this.i = n;
            this.innerPosition = f;
        }

        public String toString() {
            return "Position[ i=" + this.i + " t=" + this.innerPosition + "]";
        }
    }

    static class Segment {
        int type;
        float[] data;
        float realDistance;
        float normalizedDistance;

        public void write(PathWriter pathWriter, float f, float f2) {
            if (f == 0.0f && f2 == 1.0f) {
                if (this.type == 0) {
                    pathWriter.moveTo(this.data[0], this.data[1]);
                } else if (this.type == 1) {
                    pathWriter.lineTo(this.data[2], this.data[3]);
                } else if (this.type == 2) {
                    pathWriter.quadTo(this.data[2], this.data[3], this.data[4], this.data[5]);
                } else if (this.type == 3) {
                    pathWriter.curveTo(this.data[2], this.data[3], this.data[4], this.data[5], this.data[6], this.data[7]);
                } else {
                    throw new RuntimeException();
                }
                return;
            }
            if (f == 1.0f && f2 == 0.0f) {
                if (this.type == 0) {
                    pathWriter.moveTo(this.data[0], this.data[1]);
                } else if (this.type == 1) {
                    pathWriter.lineTo(this.data[0], this.data[1]);
                } else if (this.type == 2) {
                    pathWriter.quadTo(this.data[2], this.data[3], this.data[0], this.data[1]);
                } else if (this.type == 3) {
                    pathWriter.curveTo(this.data[4], this.data[5], this.data[2], this.data[3], this.data[0], this.data[1]);
                } else {
                    throw new RuntimeException();
                }
                return;
            }
            if (this.type == 0) {
                pathWriter.moveTo(this.data[0], this.data[1]);
            } else if (this.type == 1) {
                pathWriter.lineTo(this.getX(f2), this.getY(f2));
            } else if (this.type == 2) {
                float f3 = this.data[0] - 2.0f * this.data[2] + this.data[4];
                float f4 = -2.0f * this.data[0] + 2.0f * this.data[2];
                float f5 = this.data[0];
                float f6 = this.data[1] - 2.0f * this.data[3] + this.data[5];
                float f7 = -2.0f * this.data[1] + 2.0f * this.data[3];
                float f8 = this.data[1];
                PathWriter.quadTo(pathWriter, (double)f, (double)f2, (double)f3, (double)f4, (double)f5, (double)f6, (double)f7, (double)f8);
            } else if (this.type == 3) {
                float f9 = -this.data[0] + 3.0f * this.data[2] - 3.0f * this.data[4] + this.data[6];
                float f10 = 3.0f * this.data[0] - 6.0f * this.data[2] + 3.0f * this.data[4];
                float f11 = -3.0f * this.data[0] + 3.0f * this.data[2];
                float f12 = this.data[0];
                float f13 = -this.data[1] + 3.0f * this.data[3] - 3.0f * this.data[5] + this.data[7];
                float f14 = 3.0f * this.data[1] - 6.0f * this.data[3] + 3.0f * this.data[5];
                float f15 = -3.0f * this.data[1] + 3.0f * this.data[3];
                float f16 = this.data[1];
                PathWriter.cubicTo(pathWriter, (double)f, (double)f2, (double)f9, (double)f10, (double)f11, (double)f12, (double)f13, (double)f14, (double)f15, (double)f16);
            } else if (this.type == 4) {
                pathWriter.closePath();
            } else {
                throw new RuntimeException();
            }
        }

        public float getTangentSlope(float f) {
            if (this.type == 1) {
                float f2 = this.data[2] - this.data[0];
                float f3 = this.data[3] - this.data[1];
                return (float)Math.atan2(f3, f2);
            }
            if (this.type == 2) {
                float f4 = this.data[0] - 2.0f * this.data[2] + this.data[4];
                float f5 = -2.0f * this.data[0] + 2.0f * this.data[2];
                float f6 = this.data[1] - 2.0f * this.data[3] + this.data[5];
                float f7 = -2.0f * this.data[1] + 2.0f * this.data[3];
                return (float)Math.atan2(2.0f * f6 * f + f7, 2.0f * f4 * f + f5);
            }
            if (this.type == 3) {
                float f8 = -this.data[0] + 3.0f * this.data[2] - 3.0f * this.data[4] + this.data[6];
                float f9 = 3.0f * this.data[0] - 6.0f * this.data[2] + 3.0f * this.data[4];
                float f10 = -3.0f * this.data[0] + 3.0f * this.data[2];
                float f11 = -this.data[1] + 3.0f * this.data[3] - 3.0f * this.data[5] + this.data[7];
                float f12 = 3.0f * this.data[1] - 6.0f * this.data[3] + 3.0f * this.data[5];
                float f13 = -3.0f * this.data[1] + 3.0f * this.data[3];
                return (float)Math.atan2(3.0f * f11 * f * f + 2.0f * f12 * f + f13, 3.0f * f8 * f * f + 2.0f * f9 * f + f10);
            }
            if (this.type == 0) {
                return this.data[0];
            }
            if (this.type == 4) {
                throw new RuntimeException();
            }
            throw new RuntimeException();
        }

        public float getX(float f) {
            if (this.type == 1) {
                float f2 = this.data[2] - this.data[0];
                return f2 * f + this.data[0];
            }
            if (this.type == 2) {
                float f3 = this.data[0] - 2.0f * this.data[2] + this.data[4];
                float f4 = -2.0f * this.data[0] + 2.0f * this.data[2];
                float f5 = this.data[0];
                return (f3 * f + f4) * f + f5;
            }
            if (this.type == 3) {
                float f6 = -this.data[0] + 3.0f * this.data[2] - 3.0f * this.data[4] + this.data[6];
                float f7 = 3.0f * this.data[0] - 6.0f * this.data[2] + 3.0f * this.data[4];
                float f8 = -3.0f * this.data[0] + 3.0f * this.data[2];
                float f9 = this.data[0];
                return ((f6 * f + f7) * f + f8) * f + f9;
            }
            if (this.type == 0) {
                return this.data[0];
            }
            if (this.type == 4) {
                throw new RuntimeException();
            }
            throw new RuntimeException();
        }

        public float getY(float f) {
            if (this.type == 1) {
                float f2 = this.data[3] - this.data[1];
                return f2 * f + this.data[1];
            }
            if (this.type == 2) {
                float f3 = this.data[1] - 2.0f * this.data[3] + this.data[5];
                float f4 = -2.0f * this.data[1] + 2.0f * this.data[3];
                float f5 = this.data[1];
                return (f3 * f + f4) * f + f5;
            }
            if (this.type == 3) {
                float f6 = -this.data[1] + 3.0f * this.data[3] - 3.0f * this.data[5] + this.data[7];
                float f7 = 3.0f * this.data[1] - 6.0f * this.data[3] + 3.0f * this.data[5];
                float f8 = -3.0f * this.data[1] + 3.0f * this.data[3];
                float f9 = this.data[1];
                return ((f6 * f + f7) * f + f8) * f + f9;
            }
            if (this.type == 0) {
                return this.data[1];
            }
            if (this.type == 4) {
                throw new RuntimeException();
            }
            throw new RuntimeException();
        }

        public Segment(int n, float f, float f2, float[] fArray, float f3) {
            this.type = n;
            if (n == 0) {
                this.data = new float[]{fArray[0], fArray[1]};
                this.realDistance = 0.0f;
            } else if (n == 1) {
                this.data = new float[]{f, f2, fArray[0], fArray[1]};
                this.realDistance = (float)Math.sqrt((fArray[0] - f) * (fArray[0] - f) + (fArray[1] - f2) * (fArray[1] - f2));
            } else if (n == 4) {
                this.data = new float[0];
            } else {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                if (n == 2) {
                    d8 = 0.0;
                    d7 = f2 - 2.0f * fArray[1] + fArray[3];
                    d6 = -2.0f * f2 + 2.0f * fArray[1];
                    d5 = f2;
                    d4 = 0.0;
                    d3 = f - 2.0f * fArray[0] + fArray[2];
                    d2 = -2.0f * f + 2.0f * fArray[0];
                    d = f;
                    this.data = new float[]{f, f2, fArray[0], fArray[1], fArray[2], fArray[3]};
                } else if (n == 3) {
                    d8 = -f2 + 3.0f * fArray[1] - 3.0f * fArray[3] + fArray[5];
                    d7 = 3.0f * f2 - 6.0f * fArray[1] + 3.0f * fArray[3];
                    d6 = -3.0f * f2 + 3.0f * fArray[1];
                    d5 = f2;
                    d4 = -f + 3.0f * fArray[0] - 3.0f * fArray[2] + fArray[4];
                    d3 = 3.0f * f - 6.0f * fArray[0] + 3.0f * fArray[2];
                    d2 = -3.0f * f + 3.0f * fArray[0];
                    d = f;
                    this.data = new float[]{f, f2, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]};
                } else {
                    throw new RuntimeException("Unrecognized type: " + n);
                }
                this.realDistance = this.calculateDistance(d4, d3, d2, d, d8, d7, d6, d5, f3);
            }
        }

        private float calculateDistance(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, float f) {
            double d9 = d4;
            double d10 = d8;
            double d11 = 0.0;
            for (double d12 = (double)f; d12 < 1.0; d12 += (double)f) {
                double d13 = ((d * d12 + d2) * d12 + d3) * d12 + d4;
                double d14 = ((d5 * d12 + d6) * d12 + d7) * d12 + d8;
                d11 += Math.sqrt((d9 - d13) * (d9 - d13) + (d10 - d14) * (d10 - d14));
                d9 = d13;
                d10 = d14;
            }
            return (float)d11;
        }
    }
}

