/*
 * Decompiled with CFR 0.152.
 */
package com.bric.geom;

import com.bric.util.FloatArrayFactory;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Stack;

public class Clipper {
    private static final FloatArrayFactory floatFactory = new FloatArrayFactory();
    private static final float TOLERANCE = 1.0E-4f;

    public static GeneralPath clipToRect(Shape shape, Rectangle2D rectangle2D) {
        return Clipper.clipToRect(shape, null, rectangle2D);
    }

    public static GeneralPath clipToRect(Shape shape, AffineTransform affineTransform, Rectangle2D rectangle2D) {
        PathIterator pathIterator = shape.getPathIterator(affineTransform);
        ClippedPath clippedPath = new ClippedPath(pathIterator.getWindingRule());
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = floatFactory.getArray(6);
        float f3 = (float)rectangle2D.getY();
        float f4 = (float)rectangle2D.getX();
        float f5 = (float)(rectangle2D.getX() + rectangle2D.getWidth());
        float f6 = (float)(rectangle2D.getY() + rectangle2D.getHeight());
        boolean bl = false;
        float f7 = 0.0f;
        float f8 = 0.0f;
        LFunction lFunction = new LFunction();
        LFunction lFunction2 = new LFunction();
        QFunction qFunction = new QFunction();
        QFunction qFunction2 = new QFunction();
        CFunction cFunction = new CFunction();
        CFunction cFunction2 = new CFunction();
        Function function = null;
        Function function2 = null;
        double[] dArray = new double[16];
        while (!pathIterator.isDone()) {
            float f9;
            float f10;
            int n = pathIterator.currentSegment(fArray);
            if (n == 0) {
                f = fArray[0];
                f2 = fArray[1];
                f10 = fArray[0];
                f9 = fArray[1];
                if (f10 < f4) {
                    f10 = f4;
                }
                if (f10 > f5) {
                    f10 = f5;
                }
                if (f9 < f3) {
                    f9 = f3;
                }
                if (f9 > f6) {
                    f9 = f6;
                }
                clippedPath.moveTo(f10, f9);
                f7 = fArray[0];
                f8 = fArray[1];
            } else if (n == 4) {
                fArray[0] = f;
                fArray[1] = f2;
                n = 1;
                bl = true;
            }
            function = null;
            if (n == 1) {
                lFunction.define(f7, fArray[0]);
                lFunction2.define(f8, fArray[1]);
                function = lFunction;
                function2 = lFunction2;
            } else if (n == 2) {
                qFunction.define(f7, fArray[0], fArray[2]);
                qFunction2.define(f8, fArray[1], fArray[3]);
                function = qFunction;
                function2 = qFunction2;
            } else if (n == 3) {
                cFunction.define(f7, fArray[0], fArray[2], fArray[4]);
                cFunction2.define(f8, fArray[1], fArray[3], fArray[5]);
                function = cFunction;
                function2 = cFunction2;
            }
            if (function != null) {
                int n2 = 0;
                n2 += function.evaluateInverse(f4, dArray, n2);
                n2 += function.evaluateInverse(f5, dArray, n2);
                n2 += function2.evaluateInverse(f3, dArray, n2);
                n2 += function2.evaluateInverse(f6, dArray, n2);
                dArray[n2++] = 1.0;
                dArray[n2++] = 0.0;
                Arrays.sort(dArray, 0, n2);
                boolean bl2 = !(f7 >= f4 && f7 <= f5 && f8 >= f3 && f8 <= f6);
                for (int i = 0; i < n2; ++i) {
                    boolean bl3;
                    if (i > 0 && dArray[i] == dArray[i - 1] || !(dArray[i] > 0.0) || !(dArray[i] <= 1.0)) continue;
                    float f11 = (float)function.evaluate(dArray[i]);
                    float f12 = (float)function2.evaluate(dArray[i]);
                    f10 = f11;
                    f9 = f12;
                    if (f10 < f4) {
                        f10 = f4;
                    } else if (f10 > f5) {
                        f10 = f5;
                    }
                    if (f9 < f3) {
                        f9 = f3;
                    } else if (f9 > f6) {
                        f9 = f6;
                    }
                    boolean bl4 = !(Math.abs(f11 - f10) < 1.0E-4f) || !(Math.abs(f12 - f9) < 1.0E-4f);
                    float f13 = (float)function.evaluate((dArray[i] + dArray[i - 1]) / 2.0);
                    float f14 = (float)function2.evaluate((dArray[i] + dArray[i - 1]) / 2.0);
                    boolean bl5 = bl3 = !(f4 <= f13 && f13 <= f5 && f3 <= f14 && f14 <= f6);
                    if (function instanceof LFunction || bl4 || bl2 || bl3) {
                        clippedPath.lineTo(f10, f9);
                    } else if (function instanceof QFunction || function instanceof CFunction) {
                        clippedPath.curveTo(function, function2, dArray[i - 1], dArray[i]);
                    } else {
                        throw new RuntimeException("Unexpected condition.");
                    }
                    bl2 = bl4;
                }
                f7 = (float)function.evaluate(1.0);
                f8 = (float)function2.evaluate(1.0);
            }
            if (bl) {
                clippedPath.closePath();
                bl = false;
            }
            pathIterator.next();
        }
        clippedPath.flush();
        floatFactory.putArray(fArray);
        return clippedPath.g;
    }

    public static void clip(Graphics2D graphics2D, Shape shape) {
        Shape shape2 = graphics2D.getClip();
        if (shape2 == null) {
            graphics2D.setClip(shape);
            return;
        }
        Rectangle2D rectangle2D = null;
        Rectangle2D rectangle2D2 = null;
        if (shape2 instanceof Rectangle2D) {
            rectangle2D = (Rectangle2D)shape2;
        }
        if (shape instanceof Rectangle2D) {
            rectangle2D2 = (Rectangle2D)shape;
        }
        if (rectangle2D != null && rectangle2D2 != null) {
            graphics2D.setClip(rectangle2D.createIntersection(rectangle2D2));
            return;
        }
        if (rectangle2D2 != null && rectangle2D == null) {
            graphics2D.setClip(Clipper.clipToRect(shape2, rectangle2D2));
            return;
        }
        if (rectangle2D2 == null && rectangle2D != null) {
            graphics2D.setClip(Clipper.clipToRect(shape, rectangle2D));
            return;
        }
        graphics2D.clip(shape);
    }

    static class CFunction
    implements Function {
        double a;
        double b;
        double c;
        double d;
        double[] t2;
        double[] eqn;

        public String toString() {
            return this.a + "*t*t*t+" + this.b + "*t*t+" + this.c + "*t+" + this.d;
        }

        public void define(double d, double d2, double d3, double d4) {
            this.a = -d + 3.0 * d2 - 3.0 * d3 + d4;
            this.b = 3.0 * d - 6.0 * d2 + 3.0 * d3;
            this.c = -3.0 * d + 3.0 * d2;
            this.d = d;
        }

        public double evaluate(double d) {
            return this.a * d * d * d + this.b * d * d + this.c * d + this.d;
        }

        public double getDerivative(double d) {
            return 3.0 * this.a * d * d + 2.0 * this.b * d + this.c;
        }

        public int evaluateInverse(double d, double[] dArray, int n) {
            int n2;
            if (this.eqn == null) {
                this.eqn = new double[4];
            }
            this.eqn[0] = this.d - d;
            this.eqn[1] = this.c;
            this.eqn[2] = this.b;
            this.eqn[3] = this.a;
            if (n == 0) {
                int n3 = CubicCurve2D.solveCubic(this.eqn, dArray);
                if (n3 < 0) {
                    return 0;
                }
                return n3;
            }
            if (this.t2 == null) {
                this.t2 = new double[3];
            }
            if ((n2 = CubicCurve2D.solveCubic(this.eqn, this.t2)) < 0) {
                return 0;
            }
            for (int i = 0; i < n2; ++i) {
                dArray[n + i] = this.t2[i];
            }
            return n2;
        }
    }

    static class QFunction
    implements Function {
        double a;
        double b;
        double c;

        public String toString() {
            return this.a + "*t*t+" + this.b + "*t+" + this.c;
        }

        public void define(double d, double d2, double d3) {
            this.a = d - 2.0 * d2 + d3;
            this.b = -2.0 * d + 2.0 * d2;
            this.c = d;
        }

        public double evaluate(double d) {
            return this.a * d * d + this.b * d + this.c;
        }

        public double getDerivative(double d) {
            return 2.0 * this.a * d + this.b;
        }

        public int evaluateInverse(double d, double[] dArray, int n) {
            double d2 = this.c - d;
            double d3 = this.b * this.b - 4.0 * this.a * d2;
            if (d3 < 0.0) {
                return 0;
            }
            if (d3 == 0.0) {
                dArray[n] = -this.b / (2.0 * this.a);
                return 1;
            }
            d3 = Math.sqrt(d3);
            dArray[n++] = (-this.b + d3) / (2.0 * this.a);
            dArray[n++] = (-this.b - d3) / (2.0 * this.a);
            return 2;
        }
    }

    static class LFunction
    implements Function {
        double slope;
        double intercept;

        public void define(double d, double d2) {
            this.slope = d2 - d;
            this.intercept = d;
        }

        public String toString() {
            return this.slope + "*t+" + this.intercept;
        }

        public double evaluate(double d) {
            return this.slope * d + this.intercept;
        }

        public int evaluateInverse(double d, double[] dArray, int n) {
            dArray[n] = (d - this.intercept) / this.slope;
            return 1;
        }

        public double getDerivative(double d) {
            return this.slope;
        }
    }

    static interface Function {
        public double evaluate(double var1);

        public int evaluateInverse(double var1, double[] var3, int var4);

        public double getDerivative(double var1);
    }

    static class ClippedPath {
        public final GeneralPath g;
        private Stack uncommittedPoints = new Stack();
        private float initialX;
        private float initialY;

        public ClippedPath(int n) {
            this.g = new GeneralPath(n);
        }

        public void moveTo(float f, float f2) {
            this.flush();
            this.g.moveTo(f, f2);
            this.initialX = f;
            this.initialY = f2;
        }

        public void curveTo(Function function, Function function2, double d, double d2) {
            this.flush();
            double d3 = d2 - d;
            double d4 = function.getDerivative(d) * d3;
            double d5 = function.getDerivative(d2) * d3;
            double d6 = function2.getDerivative(d) * d3;
            double d7 = function2.getDerivative(d2) * d3;
            double d8 = function.evaluate(d);
            double d9 = function.evaluate(d2);
            double d10 = function2.evaluate(d);
            double d11 = function2.evaluate(d2);
            this.g.curveTo((float)(d8 + d4 / 3.0), (float)(d10 + d6 / 3.0), (float)(d9 - d5 / 3.0), (float)(d11 - d7 / 3.0), (float)d9, (float)d11);
        }

        public void lineTo(float f, float f2) {
            float[] fArray;
            if (this.uncommittedPoints.size() > 0 && Math.abs((fArray = (float[])this.uncommittedPoints.peek())[0] - f) < 1.0E-4f && Math.abs(fArray[1] - f2) < 1.0E-4f) {
                return;
            }
            fArray = floatFactory.getArray(2);
            fArray[0] = f;
            fArray[1] = f2;
            this.uncommittedPoints.push(fArray);
        }

        public void closePath() {
            this.lineTo(this.initialX, this.initialY);
            this.flush();
            this.g.closePath();
        }

        public void flush() {
            while (this.uncommittedPoints.size() > 0) {
                float[] fArray;
                while (this.uncommittedPoints.size() >= 3) {
                    float[] fArray2;
                    fArray = (float[])this.uncommittedPoints.get(0);
                    float[] fArray3 = (float[])this.uncommittedPoints.get(1);
                    float[] fArray4 = (float[])this.uncommittedPoints.get(2);
                    if (Math.abs(fArray[0] - fArray3[0]) < 1.0E-4f && Math.abs(fArray[0] - fArray4[0]) < 1.0E-4f) {
                        fArray2 = (float[])this.uncommittedPoints.remove(1);
                        floatFactory.putArray(fArray2);
                        continue;
                    }
                    if (!(Math.abs(fArray[1] - fArray3[1]) < 1.0E-4f) || !(Math.abs(fArray[1] - fArray4[1]) < 1.0E-4f)) break;
                    fArray2 = (float[])this.uncommittedPoints.remove(1);
                    floatFactory.putArray(fArray2);
                }
                fArray = (float[])this.uncommittedPoints.remove(0);
                this.g.lineTo(fArray[0], fArray[1]);
                floatFactory.putArray(fArray);
            }
        }
    }
}

