/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.transitions;

import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import com.bric.image.transition.vanilla.BlendTransition2D;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class TransitionLayout
extends CardLayout {
    public static final String NAME = "name";
    public static final String TRANSITION = "transition";
    public static final String DURATION = "duration";
    private static final Transition2D DEFAULT_TRANSITION = new BlendTransition2D();
    private static final long DEFAULT_DURATION = 500L;
    private static final long UNSPECIFIED_DURATION = -1L;
    private final Map<String, TransitionInfo> _components = new LinkedHashMap<String, TransitionInfo>();
    private long _defaultDuration = 500L;
    private Transition2D _defaultTransition = DEFAULT_TRANSITION;
    private boolean _mirrorTransition = true;
    private boolean _skipTransitions = false;
    private Runnable _beforeCallback = null;
    private Runnable _afterCallback = null;
    private TransitionAnimator _transitionAnimator;

    public Transition2D getDefaultTransition() {
        return this._defaultTransition;
    }

    public void setDefaultTransition(Transition2D defaultTransition) {
        this._defaultTransition = defaultTransition == null ? DEFAULT_TRANSITION : defaultTransition;
    }

    public long getDefaultDuration() {
        return this._defaultDuration;
    }

    public void setDefaultDuration(long defaultDuration) {
        this._defaultDuration = defaultDuration < 500L ? 500L : defaultDuration;
    }

    public boolean isMirrorTransition() {
        return this._mirrorTransition;
    }

    public void setMirrorTransition(boolean mirrorTransition) {
        this._mirrorTransition = mirrorTransition;
    }

    public boolean isSkipTransitions() {
        return this._skipTransitions;
    }

    public void setSkipTransitions(boolean skipTransitions) {
        this._skipTransitions = skipTransitions;
    }

    public Runnable getBeforeCallback() {
        return this._beforeCallback;
    }

    public void setBeforeCallback(Runnable callback) {
        this._beforeCallback = callback;
    }

    public Runnable getAfterCallback() {
        return this._afterCallback;
    }

    public void setAfterCallback(Runnable callback) {
        this._afterCallback = callback;
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        String name = null;
        NullTransition transition = null;
        long duration = -1L;
        if (constraints instanceof Map) {
            Map map = (Map)constraints;
            name = (String)map.get(NAME);
            if (name == null) {
                name = "card" + this._components.size();
            }
            transition = (Transition2D)map.get(TRANSITION);
            if (map.containsKey(DURATION)) {
                try {
                    duration = ((Number)map.get(DURATION)).longValue();
                }
                catch (Exception e) {
                    duration = -1L;
                }
            }
        } else {
            name = String.valueOf(constraints);
            if ("null".equals(name)) {
                name = "card" + this._components.size();
            }
        }
        if (transition == null) {
            transition = NullTransition.getInstance();
        }
        if (!(component instanceof TransitionPanel)) {
            this._components.put(name, new TransitionInfo(component, transition, duration));
        }
        super.addLayoutComponent(component, name);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (!(component instanceof TransitionPanel)) {
            for (Map.Entry<String, TransitionInfo> entry : this._components.entrySet()) {
                if (entry.getValue().getComponent() != component) continue;
                this._components.remove(entry.getKey());
                break;
            }
        }
        super.removeLayoutComponent(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void first(Container parent) {
        if (this._components.size() == 0) {
            return;
        }
        if (this._skipTransitions) {
            super.first(parent);
            return;
        }
        if (this.isAnimating()) {
            return;
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            int currentCardIndex = this.getCurrentCardIndex(parent);
            if (currentCardIndex == 0) {
                return;
            }
            this.triggerTransition(parent, 0, currentCardIndex, Direction.REVERSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void next(Container parent) {
        if (this._components.size() == 0) {
            return;
        }
        if (this._skipTransitions) {
            super.next(parent);
            return;
        }
        if (this.isAnimating()) {
            return;
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            int currentCardIndex = this.getCurrentCardIndex(parent);
            int nextCardIndex = (currentCardIndex + 1) % this._components.size();
            if (currentCardIndex == nextCardIndex) {
                return;
            }
            this.triggerTransition(parent, currentCardIndex, nextCardIndex, Direction.FORWARD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void previous(Container parent) {
        if (this._components.size() == 0) {
            return;
        }
        if (this._skipTransitions) {
            super.previous(parent);
            return;
        }
        if (this.isAnimating()) {
            return;
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            int nextCardIndex;
            int currentCardIndex = this.getCurrentCardIndex(parent);
            int n = nextCardIndex = currentCardIndex > 0 ? currentCardIndex - 1 : this._components.size() - 1;
            if (currentCardIndex == nextCardIndex) {
                return;
            }
            this.triggerTransition(parent, nextCardIndex, currentCardIndex, Direction.REVERSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void last(Container parent) {
        if (this._components.size() == 0) {
            return;
        }
        if (this._skipTransitions) {
            super.last(parent);
            return;
        }
        if (this.isAnimating()) {
            return;
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            int currentCardIndex = this.getCurrentCardIndex(parent);
            int nextCardIndex = this._components.size() - 1;
            if (currentCardIndex == nextCardIndex) {
                return;
            }
            this.triggerTransition(parent, currentCardIndex, nextCardIndex, Direction.FORWARD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show(Container parent, String name) {
        if (this._components.size() == 0) {
            return;
        }
        if (this._skipTransitions) {
            super.show(parent, name);
            return;
        }
        if (this.isAnimating()) {
            return;
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            int nextCardIndex = this.cardIndexOf(name);
            int currentCardIndex = this.getCurrentCardIndex(parent);
            if (nextCardIndex != -1 && currentCardIndex != nextCardIndex) {
                this.triggerTransition(parent, currentCardIndex < nextCardIndex ? currentCardIndex : nextCardIndex, currentCardIndex < nextCardIndex ? nextCardIndex : currentCardIndex, currentCardIndex < nextCardIndex ? Direction.FORWARD : Direction.REVERSE);
            }
        }
    }

    public int getCardCount() {
        return this._components.size();
    }

    private TransitionInfo transitionInfoAt(int index) {
        int count = 0;
        for (Map.Entry<String, TransitionInfo> entry : this._components.entrySet()) {
            if (count == index) {
                return entry.getValue();
            }
            ++count;
        }
        return null;
    }

    public String cardNameAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + index);
        }
        if (index >= this._components.size()) {
            throw new IndexOutOfBoundsException("Index is greater than or equal to cards count: " + index);
        }
        int count = 0;
        for (Map.Entry<String, TransitionInfo> entry : this._components.entrySet()) {
            if (count == index) {
                return entry.getKey();
            }
            ++count;
        }
        return "";
    }

    public int cardIndexOf(String name) {
        int index = 0;
        for (Map.Entry<String, TransitionInfo> entry : this._components.entrySet()) {
            if (entry.getKey().equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getCurrentCardIndex(Container parent) {
        int size = this._components.size();
        for (int i = 0; i < size; ++i) {
            if (!parent.getComponent(i).isVisible()) continue;
            return i;
        }
        return -1;
    }

    public String getCurrentCardName(Container parent) {
        int size = this._components.size();
        for (int i = 0; i < size; ++i) {
            if (!parent.getComponent(i).isVisible()) continue;
            return this.cardNameAt(i);
        }
        return "";
    }

    public boolean isAnimating() {
        return this._transitionAnimator != null && this._transitionAnimator.isAnimating();
    }

    private void triggerTransition(Container parent, int fromIndex, int toIndex, Direction direction) {
        if (this._transitionAnimator != null && this._transitionAnimator.isAnimating()) {
            return;
        }
        if (fromIndex < 0 || toIndex < 0) {
            return;
        }
        if (!this._mirrorTransition && direction == Direction.REVERSE) {
            direction = Direction.FORWARD;
            int index = fromIndex;
            fromIndex = toIndex;
            toIndex = index;
        }
        TransitionInfo from = this.transitionInfoAt(fromIndex);
        TransitionInfo to = this.transitionInfoAt(toIndex);
        if (from.getComponent() == null || to.getComponent() == null) {
            return;
        }
        long duration = from.getDuration();
        if (duration == -1L) {
            duration = this._defaultDuration;
        }
        Transition2D transition = from.getTransition() != NullTransition.getInstance() ? from.getTransition() : this._defaultTransition;
        this._transitionAnimator = new TransitionAnimator(from, to, parent, duration, transition, direction, this._afterCallback);
        if (this._beforeCallback != null) {
            this._beforeCallback.run();
        }
        this._transitionAnimator.play();
    }

    private static BufferedImage grabImage(Component component) {
        BufferedImage image = null;
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = genv.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        image = gc.getColorModel().hasAlpha() ? gc.createCompatibleImage(component.getSize().width, component.getSize().height) : new BufferedImage(component.getSize().width, component.getSize().height, 2);
        Graphics g = image.getGraphics();
        component.paint(g);
        g.dispose();
        return image;
    }

    private static RenderingHints getRenderingHints() {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return hints;
    }

    private static class TransitionPanel
    extends JComponent {
        private final BufferedImage _img1;
        private final BufferedImage _img2;
        private final Transition2D _transition;
        private float _progress = 0.0f;

        public TransitionPanel(Component c1, Component c2, Transition2D transition) {
            this._img1 = TransitionLayout.grabImage(c1);
            this._img2 = TransitionLayout.grabImage(c2);
            this._transition = transition;
        }

        public void setProgress(float progress) {
            this._progress = progress;
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHints(TransitionLayout.getRenderingHints());
            this._transition.paint(g2d, this._img1, this._img2, this._progress);
        }
    }

    private static class TransitionAnimator {
        private static final String NAME_CONSTRAINT = "__TransitionLayout.panel__";
        private final Timeline _timeline;
        private final Direction _direction;

        public TransitionAnimator(final TransitionInfo from, final TransitionInfo to, final Container container, long duration, Transition2D transition, final Direction direction, final Runnable callback) {
            this._direction = direction;
            final TransitionPanel panel = new TransitionPanel(from.getComponent(), to.getComponent(), transition);
            this._timeline = new Timeline((Object)container);
            this._timeline.setDuration(duration);
            this._timeline.addCallback(new TimelineCallback(){

                public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                    if (newState == Timeline.TimelineState.READY) {
                        container.add((Component)panel, TransitionAnimator.NAME_CONSTRAINT);
                        panel.setVisible(true);
                        if (direction == Direction.FORWARD) {
                            from.getComponent().setVisible(false);
                        } else {
                            to.getComponent().setVisible(false);
                        }
                    } else if (newState == Timeline.TimelineState.DONE) {
                        container.remove(panel);
                        if (direction == Direction.FORWARD) {
                            to.getComponent().setVisible(true);
                        } else {
                            from.getComponent().setVisible(true);
                        }
                        TransitionAnimator.this._timeline.cancel();
                    }
                }

                public void onTimelinePulse(float durationFraction, float timelinePosition) {
                    panel.setProgress(durationFraction);
                }
            });
            if (callback != null) {
                this._timeline.addCallback((TimelineCallback)new UIThreadTimelineCallbackAdapter(){

                    public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                        if (newState == Timeline.TimelineState.DONE) {
                            callback.run();
                        }
                    }
                });
            }
        }

        public boolean isAnimating() {
            Timeline.TimelineState state = this._timeline.getState();
            return state != Timeline.TimelineState.DONE && state != Timeline.TimelineState.IDLE;
        }

        public void play() {
            if (this._direction == Direction.FORWARD) {
                this._timeline.play();
            } else {
                this._timeline.playReverse();
            }
        }
    }

    private static class TransitionInfo {
        private final Component _component;
        private final Transition2D _transition;
        private final long _duration;

        public TransitionInfo(Component component, Transition2D transition, long duration) {
            this._component = component;
            this._transition = transition;
            this._duration = duration;
        }

        public Component getComponent() {
            return this._component;
        }

        public Transition2D getTransition() {
            return this._transition;
        }

        public long getDuration() {
            return this._duration;
        }
    }

    private static class NullTransition
    extends Transition2D {
        private static NullTransition _instance = new NullTransition();

        private NullTransition() {
        }

        private static NullTransition getInstance() {
            return _instance;
        }

        public Transition2DInstruction[] getInstructions(float progress, Dimension size) {
            return null;
        }
    }

    private static enum Direction {
        FORWARD,
        REVERSE;

    }
}

