/*
 * Decompiled with CFR 0.152.
 */
package com.bric.util;

import com.bric.math.MutableInteger;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;

public class FloatArrayFactory {
    private static FloatArrayFactory globalFactory;
    private Map map = FloatArrayFactory.createMap();
    private MutableInteger key = new MutableInteger(0);

    public static FloatArrayFactory getStaticFactory() {
        if (globalFactory == null) {
            globalFactory = new FloatArrayFactory();
        }
        return globalFactory;
    }

    private static Map createMap() {
        try {
            Class<?> clazz = Class.forName("gnu.trove.THashMap");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                if (constructorArray[i].getParameterTypes().length != 0) continue;
                return (Map)constructorArray[i].newInstance(new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getArray(int n) {
        Stack stack;
        MutableInteger mutableInteger = this.key;
        synchronized (mutableInteger) {
            this.key.value = n;
            stack = (Stack)this.map.get(this.key);
            if (stack == null) {
                stack = new Stack();
                this.map.put(new MutableInteger(n), stack);
            }
        }
        if (stack.size() == 0) {
            return new float[n];
        }
        return (float[])stack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putArray(float[] fArray) {
        Stack<float[]> stack;
        MutableInteger mutableInteger = this.key;
        synchronized (mutableInteger) {
            this.key.value = fArray.length;
            stack = (Stack<float[]>)this.map.get(this.key);
            if (stack == null) {
                stack = new Stack<float[]>();
                this.map.put(new MutableInteger(fArray.length), stack);
            }
        }
        stack.push(fArray);
    }
}

