/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;

public class WipeTransition2D
extends Transition2D {
    int direction;

    public WipeTransition2D() {
        this(1);
    }

    public WipeTransition2D(int n) {
        this.direction = n;
        if (n != 2 && n != 3 && n != 1 && n != 4) {
            throw new IllegalArgumentException();
        }
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        Rectangle2D.Double double_ = null;
        if (this.direction == 1) {
            double_ = new Rectangle2D.Double(0.0, 0.0, f * (float)dimension.width, dimension.height);
        } else if (this.direction == 2) {
            double d = (1.0f - f) * (float)dimension.width;
            double_ = new Rectangle2D.Double(d, 0.0, (double)dimension.width - d, dimension.height);
        } else if (this.direction == 4) {
            double_ = new Rectangle2D.Double(0.0, 0.0, dimension.width, f * (float)dimension.width);
        } else if (this.direction == 3) {
            double d = (1.0f - f) * (float)dimension.height;
            double_ = new Rectangle2D.Double(0.0, d, dimension.width, (double)dimension.height - d);
        }
        return new Transition2DInstruction[]{new ImageInstruction(true), new ImageInstruction(false, null, double_)};
    }

    public String toString() {
        if (this.direction == 1) {
            return "Wipe Right";
        }
        if (this.direction == 2) {
            return "Wipe Left";
        }
        if (this.direction == 4) {
            return "Wipe Down";
        }
        return "Wipe Up";
    }
}

