/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;

public class SplitTransition2D
extends Transition2D {
    int type;
    boolean in;

    public SplitTransition2D() {
        this(9, false);
    }

    public SplitTransition2D(int n, boolean bl) {
        if (n != 9 && n != 10) {
            throw new IllegalArgumentException("The type must be HORIZONTAL or VERTICAL.");
        }
        this.type = n;
        this.in = bl;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        Rectangle2D.Float float_;
        if (this.in) {
            f = 1.0f - f;
        }
        if (this.type == 9) {
            float f2 = (float)dimension.height / 2.0f * f;
            float_ = new Rectangle2D.Float(0.0f, (float)dimension.height / 2.0f - f2, dimension.width, 2.0f * f2);
        } else {
            float f3 = (float)dimension.width / 2.0f * f;
            float_ = new Rectangle2D.Float((float)dimension.width / 2.0f - f3, 0.0f, 2.0f * f3, dimension.height);
        }
        return new ImageInstruction[]{new ImageInstruction(!this.in), new ImageInstruction(this.in, null, float_)};
    }

    public String toString() {
        if (this.in && this.type == 9) {
            return "Split Horizontal In";
        }
        if (this.type == 9) {
            return "Split Horizontal Out";
        }
        if (this.in && this.type == 10) {
            return "Split Vertical In";
        }
        return "Split Vertical Out";
    }
}

