/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;

public class SlideTransition2D
extends Transition2D {
    int type;

    public SlideTransition2D() {
        this(1);
    }

    public SlideTransition2D(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("The type must be LEFT, RIGHT, UP or DOWN");
        }
        this.type = n;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        AffineTransform affineTransform = new AffineTransform();
        if (this.type == 2) {
            affineTransform.translate((float)dimension.width * (1.0f - f), 0.0);
        } else if (this.type == 1) {
            affineTransform.translate((float)dimension.width * (f - 1.0f), 0.0);
        } else if (this.type == 3) {
            affineTransform.translate(0.0, (float)dimension.height * (1.0f - f));
        } else {
            affineTransform.translate(0.0, (float)dimension.height * f - 1.0f);
        }
        return new Transition2DInstruction[]{new ImageInstruction(this.type != 4), new ImageInstruction(this.type == 4, affineTransform, null)};
    }

    public String toString() {
        if (this.type == 1) {
            return "Slide Right";
        }
        if (this.type == 2) {
            return "Slide Left";
        }
        if (this.type == 4) {
            return "Slide Down";
        }
        return "Slide Up";
    }
}

