/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.geom.TransformUtils;
import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ScaleTransition2D
extends Transition2D {
    int type;

    public ScaleTransition2D() {
        this(8);
    }

    public ScaleTransition2D(int n) {
        if (n != 7 && n != 8) {
            throw new IllegalArgumentException("type must be IN or OUT");
        }
        this.type = n;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        Point2D.Float float_ = new Point2D.Float((float)dimension.width / 2.0f, (float)dimension.height / 2.0f);
        if (this.type == 8) {
            f = 1.0f - f;
        }
        float f2 = (float)dimension.width * f;
        float f3 = (float)dimension.height * f;
        AffineTransform affineTransform = TransformUtils.createAffineTransform(new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height), new Rectangle2D.Double(((Point2D)float_).getX() - (double)(f2 / 2.0f), ((Point2D)float_).getY() - (double)(f3 / 2.0f), f2, f3));
        return new ImageInstruction[]{new ImageInstruction(this.type == 7), new ImageInstruction(this.type != 7, affineTransform, null)};
    }

    public String toString() {
        if (this.type == 7) {
            return "Scale In";
        }
        return "Scale Out";
    }
}

