/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;

public class RotateTransition2D
extends Transition2D {
    int type;

    public RotateTransition2D() {
        this(7);
    }

    public RotateTransition2D(int n) {
        if (n != 7 && n != 8) {
            throw new IllegalArgumentException("type must be IN or OUT");
        }
        this.type = n;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        if (this.type == 8) {
            f = 1.0f - f;
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(dimension.width / 2, dimension.height / 2);
        affineTransform.scale(f, f);
        affineTransform.rotate((1.0f - f) * 6.0f);
        affineTransform.translate(-dimension.width / 2, -dimension.height / 2);
        return new ImageInstruction[]{new ImageInstruction(this.type == 7), new ImageInstruction(this.type != 7, affineTransform, null)};
    }

    public String toString() {
        if (this.type == 7) {
            return "Rotate In";
        }
        return "Roate Out";
    }
}

