/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;

public class RevealTransition2D
extends Transition2D {
    int direction;

    public RevealTransition2D() {
        this(2);
    }

    public RevealTransition2D(int n) {
        if (n != 2 && n != 1 && n != 3 && n != 4) {
            throw new IllegalArgumentException("Direction must be LEFT, UP, RIGHT or DOWN");
        }
        this.direction = n;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        AffineTransform affineTransform = this.direction == 2 ? AffineTransform.getTranslateInstance(-f * (float)dimension.width, 0.0) : (this.direction == 1 ? AffineTransform.getTranslateInstance(f * (float)dimension.width, 0.0) : (this.direction == 3 ? AffineTransform.getTranslateInstance(0.0, -f * (float)dimension.height) : AffineTransform.getTranslateInstance(0.0, f * (float)dimension.height)));
        return new ImageInstruction[]{new ImageInstruction(false), new ImageInstruction(true, affineTransform, null)};
    }

    public String toString() {
        if (this.direction == 3) {
            return "Reveal Up";
        }
        if (this.direction == 2) {
            return "Reveal Left";
        }
        if (this.direction == 1) {
            return "Reveal Right";
        }
        return "Reveal Down";
    }
}

