/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class RadialWipeTransition2D
extends Transition2D {
    int type;

    public RadialWipeTransition2D() {
        this(6);
    }

    public RadialWipeTransition2D(int n) {
        if (n != 6 && n != 5) {
            throw new IllegalArgumentException("Type must be CLOCKWISE or COUNTER_CLOCKWISE.");
        }
        this.type = n;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        int n = -1;
        if (this.type == 5) {
            n = 1;
        }
        boolean bl = false;
        int n2 = Math.max(dimension.width, dimension.height);
        Area area = new Area(new Arc2D.Double(new Rectangle2D.Double(dimension.width / 2 - 2 * n2, dimension.height / 2 - 2 * n2, n2 * 4, n2 * 4), 90.0f + (float)bl * f * 360.0f, (float)n * f * 360.0f, 2));
        area.intersect(new Area(new Rectangle(0, 0, dimension.width, dimension.height)));
        return new ImageInstruction[]{new ImageInstruction(true), new ImageInstruction(false, null, area)};
    }

    public String toString() {
        if (this.type == 6) {
            return "Radial Wipe Clockwise";
        }
        return "Radial Wipe Counterclockwise";
    }
}

