/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;

public class PushTransition2D
extends Transition2D {
    int type;

    public PushTransition2D() {
        this(1);
    }

    public PushTransition2D(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("The type must be LEFT, RIGHT, UP or DOWN");
        }
        this.type = n;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        if (this.type == 2) {
            affineTransform2.translate((float)dimension.width * (1.0f - f), 0.0);
            affineTransform.translate((float)dimension.width * (1.0f - f) - (float)dimension.width, 0.0);
        } else if (this.type == 1) {
            affineTransform2.translate((float)dimension.width * (f - 1.0f), 0.0);
            affineTransform.translate((float)dimension.width * (f - 1.0f) + (float)dimension.width, 0.0);
        } else if (this.type == 3) {
            affineTransform2.translate(0.0, (float)dimension.height * (1.0f - f));
            affineTransform.translate(0.0, (float)dimension.height * (1.0f - f) - (float)dimension.height);
        } else {
            affineTransform2.translate(0.0, (float)dimension.height * (f - 1.0f));
            affineTransform.translate(0.0, (float)dimension.height * (f - 1.0f) + (float)dimension.height);
        }
        return new Transition2DInstruction[]{new ImageInstruction(true, affineTransform, null), new ImageInstruction(false, affineTransform2, null)};
    }

    public String toString() {
        if (this.type == 1) {
            return "Push Right";
        }
        if (this.type == 2) {
            return "Push Left";
        }
        if (this.type == 4) {
            return "Push Down";
        }
        return "Push Up";
    }
}

