/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.vanilla;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.GeneralPath;

public class DiamondsTransition2D
extends Transition2D {
    int diamondSize;

    public DiamondsTransition2D() {
        this(50);
    }

    public DiamondsTransition2D(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("size (" + n + ") must be greater than 4");
        }
        this.diamondSize = n;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        GeneralPath generalPath = new GeneralPath(1);
        float f2 = (float)dimension.height / 2.0f;
        for (float f3 = (float)dimension.width / 2.0f; f3 > (float)(0 + this.diamondSize); f3 -= (float)this.diamondSize) {
        }
        while (f2 > (float)(0 + this.diamondSize)) {
            f2 -= (float)this.diamondSize;
        }
        int n = 0;
        f /= 2.0f;
        for (float f4 = -f2; f4 < (float)(dimension.height + this.diamondSize); f4 += (float)(this.diamondSize / 2)) {
            float f5 = 0.0f;
            if (n % 2 == 0) {
                f5 = (float)this.diamondSize / 2.0f;
            }
            for (float f6 = -f3; f6 < (float)(dimension.width + this.diamondSize); f6 += (float)this.diamondSize) {
                generalPath.moveTo(f6 + f5, f4 - (float)this.diamondSize * f);
                generalPath.lineTo(f6 + (float)this.diamondSize * f + f5, f4);
                generalPath.lineTo(f6 + f5, f4 + (float)this.diamondSize * f);
                generalPath.lineTo(f6 - (float)this.diamondSize * f + f5, f4);
                generalPath.lineTo(f6 + f5, f4 - (float)this.diamondSize * f);
                generalPath.closePath();
            }
            ++n;
        }
        return new Transition2DInstruction[]{new ImageInstruction(true), new ImageInstruction(false, null, generalPath)};
    }

    public String toString() {
        return "Diamonds (" + this.diamondSize + ")";
    }
}

