/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.spunk;

import com.bric.geom.TransformUtils;
import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class WaveTransition2D
extends Transition2D {
    int type = 1;

    public WaveTransition2D() {
    }

    public WaveTransition2D(int n) {
        if (n != 2 && n != 1 && n != 4 && n != 3) {
            throw new IllegalArgumentException("Type must be LEFT, UP, RIGHT or DOWN");
        }
        this.type = n;
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        int n = dimension.height / 5;
        Transition2DInstruction[] transition2DInstructionArray = new Transition2DInstruction[n + 1];
        float f2 = (float)Math.sqrt(f);
        transition2DInstructionArray[0] = new ImageInstruction(true);
        int n2 = dimension.width;
        if (this.type == 3 || this.type == 4) {
            n2 = dimension.height;
        }
        double d = 0.0;
        for (int i = 0; i < transition2DInstructionArray.length; ++i) {
            float f3 = (float)(i - 1) / (float)(transition2DInstructionArray.length - 1);
            float f4 = (float)i / (float)(transition2DInstructionArray.length - 1);
            AffineTransform affineTransform = new AffineTransform();
            float f5 = (float)(0.3 * Math.sin(1.0f + 3.0f * f3 + 8.0f * f));
            float f6 = 1.0f - 0.5f * (2.0f * f - 1.0f) * (2.0f * f - 1.0f) * (2.0f * f - 1.0f) - 0.5f;
            double d2 = (double)((1.0f - f2) * (float)n2) + (double)((1.0f - f4) * f6) * ((double)(f4 + f5) + 0.4) * (double)n2;
            if (i > 0) {
                Rectangle2D.Float float_;
                if (this.type == 2 || this.type == 1) {
                    float_ = new Rectangle2D.Float(0.0f, f3 * (float)dimension.height, dimension.width, f4 * (float)dimension.height - f3 * (float)dimension.height + 1.0f);
                    affineTransform = this.type == 2 ? TransformUtils.createAffineTransform(0.0, f4 * (float)dimension.height, 0.0, f3 * (float)dimension.height, dimension.width, f4 * (float)dimension.height, d2, f4 * (float)dimension.height, d, f3 * (float)dimension.height, d2 + (double)dimension.width, f4 * (float)dimension.height) : TransformUtils.createAffineTransform(dimension.width, f4 * (float)dimension.height, dimension.width, f3 * (float)dimension.height, 0.0, f4 * (float)dimension.height, (double)dimension.width - d2, f4 * (float)dimension.height, (double)dimension.width - d, f3 * (float)dimension.height, (double)dimension.width - d2 - (double)dimension.width, f4 * (float)dimension.height);
                } else {
                    float_ = new Rectangle2D.Float(f3 * (float)dimension.width, 0.0f, f4 * (float)dimension.width - f3 * (float)dimension.width + 1.0f, dimension.height);
                    affineTransform = this.type == 3 ? TransformUtils.createAffineTransform(f4 * (float)dimension.width, 0.0, f3 * (float)dimension.width, 0.0, f4 * (float)dimension.width, dimension.height, f4 * (float)dimension.width, d2, f3 * (float)dimension.width, d, f4 * (float)dimension.width, d2 + (double)dimension.height) : TransformUtils.createAffineTransform(f4 * (float)dimension.width, dimension.height, f3 * (float)dimension.width, dimension.height, f4 * (float)dimension.width, 0.0, f4 * (float)dimension.width, (double)dimension.height - d2, f3 * (float)dimension.width, (double)dimension.height - d, f4 * (float)dimension.width, (double)dimension.height - d2 - (double)dimension.height);
                }
                transition2DInstructionArray[i] = new ImageInstruction(false, affineTransform, affineTransform.createTransformedShape(float_));
            }
            d = d2;
        }
        return transition2DInstructionArray;
    }

    public String toString() {
        if (this.type == 3) {
            return "Wave Up";
        }
        if (this.type == 4) {
            return "Wave Down";
        }
        if (this.type == 1) {
            return "Wave Right";
        }
        return "Wave Left";
    }
}

