/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.spunk;

import com.bric.image.transition.spunk.AbstractPlanarTransition2D;
import java.awt.geom.Point2D;

public class SwivelTransition2D
extends AbstractPlanarTransition2D {
    int multiplier;

    public SwivelTransition2D() {
        this(6);
    }

    public SwivelTransition2D(int n) {
        if (n == 6) {
            this.multiplier = 1;
        } else if (n == 5) {
            this.multiplier = -1;
        } else {
            throw new IllegalArgumentException("The direction must be CLOCKWISE or COUNTER_CLOCKWISE");
        }
    }

    public String toString() {
        if (this.multiplier == -1) {
            return "Swivel Counterclockwise";
        }
        return "Swivel Clockwise";
    }

    public float getFrameAOpacity(float f) {
        if (f < 0.5f) {
            return 1.0f;
        }
        f = 1.0f - (f - 0.5f) / 0.5f;
        f = (float)Math.sqrt(f);
        return f;
    }

    public float getFrameBOpacity(float f) {
        if (f > 0.5f) {
            return 1.0f;
        }
        f /= 0.5f;
        f = (float)Math.pow(f, 0.5);
        return f;
    }

    public Point2D getFrameALocation(float f) {
        f = (float)this.multiplier * f;
        return new Point2D.Double(0.5 * Math.cos(Math.PI * (double)f + 1.5707963267948966) + 0.5, 0.5 * Math.sin(Math.PI * (double)f + 1.5707963267948966) + 0.5);
    }

    public Point2D getFrameBLocation(float f) {
        f = (float)this.multiplier * f;
        return new Point2D.Double(0.5 * Math.cos(Math.PI * (double)f + 4.71238898038469) + 0.5, 0.5 * Math.sin(Math.PI * (double)f + 4.71238898038469) + 0.5);
    }
}

