/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.spunk;

import com.bric.geom.ShapeBounds;
import com.bric.geom.ShapeStringUtils;
import com.bric.geom.ShapeUtils;
import com.bric.geom.TransformUtils;
import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2DInstruction;
import com.bric.image.transition.spunk.AbstractClippedTransition2D;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;
import java.util.Vector;

public class StarsTransition2D
extends AbstractClippedTransition2D {
    static GeneralPath[] star = new GeneralPath[]{StarsTransition2D.createStar(1.5f), StarsTransition2D.createStar(1.6f), StarsTransition2D.createStar(1.7f), StarsTransition2D.createStar(1.8f), StarsTransition2D.createStar(1.9f), StarsTransition2D.createStar(2.0f), StarsTransition2D.createStar(2.1f), StarsTransition2D.createStar(2.2f), StarsTransition2D.createStar(2.3f)};
    int type = 1;
    GeneralPath[] paths = new GeneralPath[]{ShapeStringUtils.createGeneralPath("m 82.604 6.405 c 81.496 6.405 58.748 5.967 57.234 5.937 c 48.657 5.767 39.783 5.605 30.4 11.819 c 19.367 19.125 9.915 39.783 23.713 50.988 c 35.754 60.766 50.748 54.184 53.807 47.734 c 56.105 42.887 49.464 38.223 45.159 38.223"), ShapeStringUtils.createGeneralPath("m 130.936 47.089 c 130.636 46.6 113.679 45.149 103.386 45.364 c 94.251 45.555 88.013 49.832 82.977 54.875 c 75.353 62.51 70.458 72.743 73.292 82.281 c 76.126 91.818 93.239 89.414 93.239 89.414 c 93.239 89.414 101.796 85.728 100.734 78.276 c 99.683 70.903 96.561 71.393 93.124 71.393 c 84.366 71.393 85.661 83.327 94.277 78.651"), ShapeStringUtils.createGeneralPath("m 124.379 23.124 c 124.044 24.216 107.26 20.206 97.997 21.225 c 88.734 22.245 74.072 27.614 64.329 38.119 c 54.586 48.624 52.078 53.184 52.683 61.27 c 53.288 69.356 71.622 78.91 77.935 66.901")};

    private static GeneralPath createStar(float f) {
        GeneralPath generalPath = new GeneralPath();
        double d = 0.0;
        double d2 = 0.6283185307179586;
        generalPath.moveTo((float)Math.cos(d), (float)Math.sin(d));
        for (int i = 0; i < 5; ++i) {
            generalPath.lineTo((float)((double)f * Math.cos(d + d2)), (float)((double)f * Math.sin(d + d2)));
            generalPath.lineTo((float)Math.cos(d += 1.2566370614359172), (float)Math.sin(d));
        }
        generalPath.closePath();
        return generalPath;
    }

    public StarsTransition2D() {
        this(1);
    }

    public StarsTransition2D(int n) {
        if (n != 2 && n != 1) {
            throw new IllegalArgumentException("This transition must use type RIGHT or LEFT");
        }
        this.type = n;
    }

    public String toString() {
        if (this.type == 1) {
            return "Stars Right";
        }
        return "Stars Left";
    }

    protected void fit(GeneralPath generalPath, float f, float f2, float f3, GeneralPath generalPath2, Dimension dimension, float f4) {
        Rectangle2D rectangle2D = generalPath.getBounds2D();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-rectangle2D.getX() - rectangle2D.getWidth() / 2.0, -rectangle2D.getY() - rectangle2D.getHeight() / 2.0);
        affineTransform.rotate((1.0f - f4) * 1.0f);
        double d = Math.pow(f4, 3.0) * 0.75;
        affineTransform.scale((double)f / rectangle2D.getWidth() * (0.02 + 1.8 * d), (double)f / rectangle2D.getWidth() * (0.02 + 1.8 * d));
        generalPath.transform(affineTransform);
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        Point2D point2D = ShapeUtils.getPoint(generalPath2, 1.0f);
        Point2D point2D2 = ShapeUtils.getPoint(generalPath2, f4);
        Rectangle2D rectangle2D2 = ShapeBounds.getBounds(generalPath2);
        AffineTransform affineTransform2 = TransformUtils.createAffineTransform(rectangle2D2, new Rectangle2D.Float(0.0f, 0.0f, dimension.width + 100, dimension.height));
        affineTransform2.transform(point2D, point2D);
        affineTransform2.transform(point2D2, point2D2);
        rectangle2D = generalPath.getBounds();
        affineTransform.setToTranslation(-rectangle2D.getCenterX() + (double)f2 - point2D.getX() + point2D2.getX(), -rectangle2D.getCenterY() + (double)f3 - point2D.getY() + point2D2.getY());
        generalPath.transform(affineTransform);
    }

    public Shape[] getShapes(float f, Dimension dimension) {
        f = 1.0f - f;
        GeneralPath generalPath = new GeneralPath(star[8]);
        GeneralPath generalPath2 = new GeneralPath(star[5]);
        GeneralPath generalPath3 = new GeneralPath(star[8]);
        GeneralPath generalPath4 = new GeneralPath(star[5]);
        GeneralPath generalPath5 = new GeneralPath(star[7]);
        GeneralPath generalPath6 = new GeneralPath(star[5]);
        GeneralPath generalPath7 = new GeneralPath(star[8]);
        GeneralPath generalPath8 = new GeneralPath(star[6]);
        Random random = new Random(2L);
        generalPath.transform(AffineTransform.getRotateInstance(random.nextDouble()));
        generalPath2.transform(AffineTransform.getRotateInstance(random.nextDouble()));
        generalPath3.transform(AffineTransform.getRotateInstance(random.nextDouble()));
        generalPath4.transform(AffineTransform.getRotateInstance(random.nextDouble()));
        generalPath5.transform(AffineTransform.getRotateInstance(random.nextDouble()));
        generalPath6.transform(AffineTransform.getRotateInstance(random.nextDouble()));
        generalPath7.transform(AffineTransform.getRotateInstance(random.nextDouble()));
        generalPath8.transform(AffineTransform.getRotateInstance(random.nextDouble()));
        float f2 = (float)Math.min(dimension.width, dimension.height) * 0.7f;
        float f3 = (float)(Math.pow(f, 2.2) * 0.5 + 0.0);
        float f4 = (float)(Math.pow(f, 2.2) * 0.5 + (double)0.0375f);
        float f5 = (float)(Math.pow(f, 2.2) * 0.5 + (double)0.075f);
        float f6 = (float)(Math.pow(f, 2.2) * 0.5 + 0.11250000447034836);
        float f7 = (float)(Math.pow(f, 2.2) * 0.5 + (double)0.15f);
        float f8 = (float)(Math.pow(f, 2.2) * 0.5 + 0.1875);
        float f9 = (float)(Math.pow(f, 2.2) * 0.5 + 0.22500000894069672);
        float f10 = (float)(Math.pow(f, 2.2) * 0.5 + 0.26250001788139343);
        float f11 = (f - f3) / (1.0f - f3);
        float f12 = (f - f4) / (1.0f - f4);
        float f13 = (f - f5) / (1.0f - f5);
        float f14 = (f - f6) / (1.0f - f6);
        float f15 = (f - f7) / (1.0f - f7);
        float f16 = (f - f8) / (1.0f - f8);
        float f17 = (f - f9) / (1.0f - f9);
        float f18 = (f - f10) / (1.0f - f10);
        Vector<GeneralPath> vector = new Vector<GeneralPath>();
        if (f11 > 0.0f) {
            this.fit(generalPath, f2, (float)dimension.width * 2.0f / 3.0f, (float)dimension.height * 3.0f / 4.0f, this.paths[0], dimension, f11 * 2.0f);
            vector.add(generalPath);
        }
        if (f12 > 0.0f) {
            this.fit(generalPath2, f2, (float)dimension.width * 7.0f / 8.0f, (float)dimension.height * 1.0f / 5.0f, this.paths[1], dimension, f12 * 2.0f);
            vector.add(generalPath2);
        }
        if (f13 > 0.0f) {
            this.fit(generalPath3, f2, (float)dimension.width * 1.0f / 6.0f, (float)dimension.height * 2.2f / 5.0f, this.paths[2], dimension, f13 * 2.0f);
            vector.add(generalPath3);
        }
        if (f14 > 0.0f) {
            this.fit(generalPath4, f2, (float)dimension.width * 3.1f / 6.0f, (float)dimension.height * 1.2f / 5.0f, this.paths[0], dimension, f14 * 2.0f);
            vector.add(generalPath4);
        }
        if (f15 > 0.0f) {
            this.fit(generalPath5, f2, (float)dimension.width * 1.9f / 6.0f, (float)dimension.height * 4.2f / 5.0f, this.paths[1], dimension, f15 * 2.0f);
            vector.add(generalPath5);
        }
        if (f16 > 0.0f) {
            this.fit(generalPath6, f2, (float)dimension.width * 13.0f / 15.0f, (float)dimension.height * 4.3f / 5.0f, this.paths[2], dimension, f16 * 2.0f);
            vector.add(generalPath6);
        }
        if (f17 > 0.0f) {
            this.fit(generalPath7, f2, (float)dimension.width * 2.0f / 5.0f, (float)dimension.height * 2.4f / 5.0f, this.paths[0], dimension, f17 * 2.0f);
            vector.add(generalPath7);
        }
        if (f18 > 0.0f) {
            this.fit(generalPath8, f2, (float)dimension.width * 3.0f / 6.0f, (float)dimension.height * 2.0f / 5.0f, this.paths[2], dimension, f18 * 2.0f);
            vector.add(generalPath8);
        }
        Shape[] shapeArray = vector.toArray(new Shape[vector.size()]);
        if (this.type == 2) {
            AffineTransform affineTransform = TransformUtils.createAffineTransform(0.0, 0.0, 0.0, dimension.height, dimension.width, 0.0, dimension.width, 0.0, dimension.width, dimension.height, 0.0, 0.0);
            for (int i = 0; i < shapeArray.length; ++i) {
                if (shapeArray[i] instanceof GeneralPath) {
                    ((GeneralPath)shapeArray[i]).transform(affineTransform);
                    continue;
                }
                shapeArray[i] = affineTransform.createTransformedShape(shapeArray[i]);
            }
        }
        return shapeArray;
    }

    public float getStrokeWidth(float f) {
        return 2.0f + 7.0f * (1.0f - f);
    }

    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        Transition2DInstruction[] transition2DInstructionArray = super.getInstructions(f, dimension);
        for (int i = 0; i < transition2DInstructionArray.length; ++i) {
            if (!(transition2DInstructionArray[i] instanceof ImageInstruction)) continue;
            ImageInstruction imageInstruction = (ImageInstruction)transition2DInstructionArray[i];
            imageInstruction.isFirstFrame = !imageInstruction.isFirstFrame;
        }
        return transition2DInstructionArray;
    }
}

