/*
 * Decompiled with CFR 0.152.
 */
package com.bric.image.transition.spunk;

import com.bric.image.transition.ImageInstruction;
import com.bric.image.transition.Transition2D;
import com.bric.image.transition.Transition2DInstruction;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class MeshShuffleTransition2D
extends Transition2D {
    public Transition2DInstruction[] getInstructions(float f, Dimension dimension) {
        f = (float)Math.pow(f, 0.45);
        float f2 = dimension.height * 10 / 200;
        Vector<Rectangle2D.Float> vector = new Vector<Rectangle2D.Float>();
        int n = dimension.height;
        while ((float)n > -f2) {
            vector.add(new Rectangle2D.Float(0.0f, n, dimension.width, f2));
            n = (int)((float)n - f2);
        }
        Transition2DInstruction[] transition2DInstructionArray = new Transition2DInstruction[vector.size()];
        transition2DInstructionArray[0] = new ImageInstruction(true);
        for (int i = 1; i < vector.size(); ++i) {
            Rectangle2D rectangle2D = (Rectangle2D)vector.get(i);
            AffineTransform affineTransform = new AffineTransform();
            float f3 = (1.0f - f) * (float)i / (float)vector.size();
            float f4 = (float)(Math.PI * (double)f3 / 2.0 + (double)(1.0f - f) * Math.PI / 2.0);
            if ((double)f4 > 1.5707963267948966) {
                f4 = 1.5707964f;
            }
            if (i % 2 == 0) {
                affineTransform.rotate(-f4, (float)(-dimension.width) * (1.0f - f) / 2.0f, (float)dimension.height * f);
            } else {
                affineTransform.rotate(f4, (float)dimension.width + (1.0f - f) * (float)dimension.width / 2.0f, (float)dimension.height * f);
            }
            transition2DInstructionArray[i] = new ImageInstruction(false, affineTransform, affineTransform.createTransformedShape(rectangle2D));
        }
        return transition2DInstructionArray;
    }

    public String toString() {
        return "Mesh Shuffle";
    }
}

