/*
 * Decompiled with CFR 0.152.
 */
package com.bric.geom;

import com.bric.geom.PathWriter;
import java.awt.geom.GeneralPath;

public class GeneralPathWriter
extends PathWriter {
    GeneralPath p;
    float lastX;
    float lastY;
    boolean dataWritten = false;
    boolean debug = false;

    public GeneralPathWriter(GeneralPath generalPath) {
        this.p = generalPath;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void flush() {
    }

    public void reset() {
        if (this.debug) {
            System.out.println("reset()");
        }
        this.p.reset();
        this.dataWritten = false;
    }

    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.debug) {
            System.out.println("curveTo( " + f + ", " + f2 + ", " + f3 + ", " + f4 + ", " + f5 + ", " + f6 + ")");
        }
        this.p.curveTo(f, f2, f3, f4, f5, f6);
        this.lastX = f5;
        this.lastY = f6;
        this.dataWritten = true;
    }

    public void lineTo(float f, float f2) {
        if (GeneralPathWriter.equals(this.lastX, f) && GeneralPathWriter.equals(this.lastY, f2)) {
            return;
        }
        if (this.debug) {
            System.out.println("lineTo( " + f + ", " + f2 + ")");
        }
        this.p.lineTo(f, f2);
        this.lastX = f;
        this.lastY = f2;
        this.dataWritten = true;
    }

    public void moveTo(float f, float f2) {
        this.p.moveTo(f, f2);
        if (this.debug) {
            System.out.println("moveTo( " + f + ", " + f2 + ")");
        }
        this.lastX = f;
        this.lastY = f2;
        this.dataWritten = true;
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        this.p.quadTo(f, f2, f3, f4);
        if (this.debug) {
            System.out.println("quadTo( " + f + ", " + f2 + ", " + f3 + ", " + f4 + ")");
        }
        this.lastX = f3;
        this.lastY = f4;
        this.dataWritten = true;
    }

    public void closePath() {
        if (this.dataWritten) {
            this.p.closePath();
            if (this.debug) {
                System.out.println("closePath()");
            }
            this.dataWritten = false;
        }
    }

    private static boolean equals(float f, float f2) {
        float f3 = f2 - f;
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        return f3 < 0.001f;
    }
}

