/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.util;

import griffon.core.UIThreadManager;
import griffon.util.UIThreadWorker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.codehaus.griffon.runtime.core.AbstractObservable;
import org.codehaus.griffon.runtime.util.ExecutorServiceHolder;

public abstract class AbstractUIThreadWorker<T, V>
extends AbstractObservable
implements UIThreadWorker<T, V> {
    private volatile int progress;
    private volatile UIThreadWorker.StateValue state;
    private final FutureTask<T> future;
    private static final String KEY_PROGRESS = "progress";
    private static final String KEY_STATE = "state";
    private static final ExecutorService DEFAULT_EXECUTOR_SERVICE = ExecutorServiceHolder.add((ExecutorService)Executors.newFixedThreadPool(10));

    public AbstractUIThreadWorker() {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                AbstractUIThreadWorker.this.setState(UIThreadWorker.StateValue.STARTED);
                return AbstractUIThreadWorker.this.doInBackground();
            }
        };
        this.future = new FutureTask<T>(callable){

            @Override
            protected void done() {
                AbstractUIThreadWorker.this.callDoneInsideUIThread();
                AbstractUIThreadWorker.this.setState(UIThreadWorker.StateValue.DONE);
            }
        };
        this.state = UIThreadWorker.StateValue.PENDING;
    }

    protected abstract T doInBackground() throws Exception;

    protected void process(List<V> chunks) {
    }

    protected void done() {
    }

    protected final void publish(V ... chunks) {
        final ArrayList args = new ArrayList();
        Collections.addAll(args, chunks);
        UIThreadManager.getInstance().executeSync(new Runnable(){

            @Override
            public void run() {
                AbstractUIThreadWorker.this.process(args);
            }
        });
    }

    @Override
    public final void run() {
        this.future.run();
    }

    protected final void setProgress(final int progress) {
        if (progress < 0 || progress > 100) {
            throw new IllegalArgumentException("Value should be from 0 to 100");
        }
        if (this.progress == progress) {
            return;
        }
        final int oldProgress = this.progress;
        this.progress = progress;
        if (!this.pcs.hasListeners(KEY_PROGRESS)) {
            return;
        }
        UIThreadManager.getInstance().executeSync(new Runnable(){

            @Override
            public void run() {
                AbstractUIThreadWorker.this.firePropertyChange(AbstractUIThreadWorker.KEY_PROGRESS, oldProgress, progress);
            }
        });
    }

    @Override
    public final int getProgress() {
        return this.progress;
    }

    @Override
    public final UIThreadWorker.StateValue getState() {
        return this.isDone() ? UIThreadWorker.StateValue.DONE : this.state;
    }

    private void setState(UIThreadWorker.StateValue state) {
        this.state = state;
        this.pcs.firePropertyChange(KEY_STATE, (Object)this.state, (Object)this.state);
    }

    @Override
    public final void execute() {
        DEFAULT_EXECUTOR_SERVICE.submit(this);
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public final boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    private void callDoneInsideUIThread() {
        UIThreadManager.getInstance().executeSync(new Runnable(){

            @Override
            public void run() {
                AbstractUIThreadWorker.this.done();
            }
        });
    }
}

