/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.tasks;

import griffon.plugins.tasks.ExceptionHandler;
import java.util.EventListener;
import org.slf4j.Logger;

public class LoggingExceptionHandler<T extends EventListener>
implements ExceptionHandler<T> {
    private final Logger log;
    private boolean notifyOtherListeners = true;

    public LoggingExceptionHandler(Logger log) {
        this.log = log;
        this.notifyOtherListeners = true;
    }

    public LoggingExceptionHandler(Logger log, boolean notifyOtherListeners) {
        this.log = log;
        this.notifyOtherListeners = notifyOtherListeners;
    }

    public boolean isNotifyOtherListeners() {
        return this.notifyOtherListeners;
    }

    public void setNotifyOtherListeners(boolean notifyOtherListeners) {
        this.notifyOtherListeners = notifyOtherListeners;
    }

    public static <T extends EventListener> LoggingExceptionHandler<T> newInstance(Logger log) {
        return new LoggingExceptionHandler<T>(log);
    }

    @Override
    public boolean handleException(T listener, Throwable t) throws Throwable {
        this.log.error("Listener '" + listener + "' threw an exception: " + t.getMessage(), t);
        return this.notifyOtherListeners;
    }
}

