/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.tasks;

import griffon.plugins.tasks.ExceptionHandler;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEmitter<T extends EventListener>
implements Iterable<T> {
    private static final Logger log = LoggerFactory.getLogger(EventEmitter.class);
    private final Class<T> listenerClass;
    private final CopyOnWriteArrayList<T> listeners = new CopyOnWriteArrayList();
    private final T emitter;
    private volatile ExceptionHandler<T> exceptionHandler = ExceptionHandler.RETHROW_EXCEPTION_HANDLER;

    public EventEmitter(Class<T> clazz, ClassLoader loader, ExceptionHandler<T> handler) {
        ClassLoader l = loader;
        if (l == null && (l = clazz.getClassLoader()) == null) {
            log.warn("Given ClassLoader is null. Using ContextClassLoader from current thread.");
            l = Thread.currentThread().getContextClassLoader();
        }
        this.emitter = (EventListener)Proxy.newProxyInstance(l, new Class[]{clazz}, this.createInvocationHandler());
        this.listenerClass = clazz;
        if (handler != null) {
            this.exceptionHandler = handler;
        }
    }

    public static <T extends EventListener> EventEmitter<T> newEmitter(Class<T> listenerClass) {
        return EventEmitter.newEmitter(listenerClass, listenerClass.getClassLoader());
    }

    public static <T extends EventListener> EventEmitter<T> newEmitter(Class<T> listenerClass, ClassLoader loader) {
        return EventEmitter.newEmitter(listenerClass, loader, null);
    }

    public static <T extends EventListener> EventEmitter<T> newEmitter(Class<T> listenerClass, ExceptionHandler<T> handler) {
        return EventEmitter.newEmitter(listenerClass, listenerClass.getClassLoader(), handler);
    }

    public static <T extends EventListener> EventEmitter<T> newEmitter(Class<T> listenerClass, ClassLoader loader, ExceptionHandler<T> handler) {
        return new EventEmitter<T>(listenerClass, loader, null);
    }

    public void addListener(T listener) {
        this.listeners.add(listener);
    }

    public void removeListener(T listener) {
        this.listeners.remove(listener);
    }

    public T[] getListeners() {
        Object[] objArray = this.listeners.toArray();
        EventListener[] listeners = (EventListener[])Array.newInstance(this.listenerClass, objArray.length);
        System.arraycopy(objArray, 0, listeners, 0, objArray.length);
        return listeners;
    }

    public void setExceptionHandler(ExceptionHandler<T> exceptionHandler) {
        if (exceptionHandler != null) {
            this.exceptionHandler = exceptionHandler;
        }
    }

    public int getListenerCount() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.listeners.iterator();
    }

    public T emitter() {
        return this.emitter;
    }

    protected InvocationHandler createInvocationHandler() {
        return new EventInvocationHandler();
    }

    protected class EventInvocationHandler
    implements InvocationHandler {
        protected EventInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            EventListener l;
            boolean keeprunning;
            Iterator i$ = EventEmitter.this.iterator();
            while (i$.hasNext() && (keeprunning = this.invokeListener(l = (EventListener)i$.next(), method, args))) {
            }
            return null;
        }

        protected boolean invokeListener(T l, Method method, Object[] args) throws Throwable {
            try {
                method.invoke(l, args);
                return true;
            }
            catch (InvocationTargetException e) {
                return EventEmitter.this.exceptionHandler.handleException(l, e.getTargetException());
            }
        }
    }
}

