/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.tasks;

import griffon.plugins.tasks.Task;
import griffon.plugins.tasks.TaskContext;
import griffon.plugins.tasks.TaskWorker;
import griffon.util.UIThreadWorker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.codehaus.griffon.runtime.tasks.DefaultTracker;
import org.codehaus.griffon.runtime.util.AbstractUIThreadWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskWorker<V, C>
extends AbstractUIThreadWorker<V, C>
implements PropertyChangeListener,
TaskWorker<V, C> {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskWorker.class);
    private final Task<V, C> task;
    private String phase;
    private Long startedTimestamp = null;
    private Long finishedTimestamp = null;
    private boolean error = false;
    private TaskContext context;

    public DefaultTaskWorker(Task<V, C> task) {
        this.task = task;
        this.addPropertyChangeListener(this);
    }

    @Override
    protected V doInBackground() throws Exception {
        DefaultTracker tracker = new DefaultTracker(this);
        return this.task.execute(tracker);
    }

    @Override
    protected void process(List<C> chunks) {
        this.task.process(chunks);
    }

    @Override
    public void setContext(TaskContext context) {
        this.context = context;
    }

    @Override
    protected void done() {
        this.finishedTimestamp = System.currentTimeMillis();
        try {
            this.task.done(this.get());
        }
        catch (InterruptedException e) {
            log.error("Interrupted during get()", (Throwable)e);
            this.task.failed(e);
        }
        catch (CancellationException e) {
            log.debug("Task '{}/{}' cancelled by user", (Object)this.task.getId(), (Object)this.getContextId());
            this.task.failed(e);
        }
        catch (Exception e) {
            this.error = true;
            log.debug("Error executing task " + this.task.getId() + "/" + this.getContextId(), (Throwable)e);
            if (e instanceof ExecutionException) {
                ExecutionException executionException = (ExecutionException)e;
                this.task.failed(e.getCause());
            }
            this.task.failed(e);
        }
    }

    private String getContextId() {
        if (this.context != null) {
            return this.context.getContextId();
        }
        return null;
    }

    @Override
    public Long getStartedTimestamp() {
        return this.startedTimestamp;
    }

    @Override
    public Long getFinishTimestamp() {
        return this.finishedTimestamp;
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public Task<V, C> getTask() {
        return this.task;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("state") && evt.getOldValue() instanceof UIThreadWorker.StateValue && evt.getNewValue() instanceof UIThreadWorker.StateValue) {
            UIThreadWorker.StateValue o = (UIThreadWorker.StateValue)((Object)evt.getOldValue());
            UIThreadWorker.StateValue n = (UIThreadWorker.StateValue)((Object)evt.getNewValue());
            if (o == UIThreadWorker.StateValue.PENDING && n == UIThreadWorker.StateValue.STARTED) {
                this.startedTimestamp = System.currentTimeMillis();
            }
        }
    }

    @Override
    public void publishProgress(int progress) {
        super.setProgress(progress);
    }

    @Override
    public void publishChunks(C ... chunks) {
        super.publish(chunks);
    }

    @Override
    public void setPhase(String phase) {
        String oldphase = this.phase;
        this.phase = phase;
        this.firePropertyChange("phase", oldphase, phase);
    }
}

