/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.tasks;

import griffon.plugins.tasks.ChangeEvent;
import griffon.plugins.tasks.Task;
import griffon.plugins.tasks.TaskBlocker;
import griffon.plugins.tasks.TaskContext;
import griffon.plugins.tasks.TaskControl;
import griffon.plugins.tasks.TaskListenerSupport;
import griffon.plugins.tasks.TaskManager;
import griffon.plugins.tasks.TaskPredicate;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.codehaus.griffon.runtime.tasks.DefaultTaskContext;
import org.codehaus.griffon.runtime.tasks.DefaultTaskControl;
import org.codehaus.griffon.runtime.tasks.DefaultTaskListenerSupport;
import org.codehaus.griffon.runtime.tasks.DefaultTaskWorker;
import org.codehaus.griffon.runtime.tasks.TaskIterable;
import org.codehaus.griffon.runtime.tasks.TaskListenerAdapter;

public class DefaultTaskManager
implements TaskManager {
    private final TaskListenerSupport taskListenerSupport;
    private final Map<String, TaskControl> tasks = new ConcurrentHashMap<String, TaskControl>();
    private final ExecutorService executorService;

    public DefaultTaskManager(final TaskBlocker blocker) {
        this.taskListenerSupport = this.createTaskListenerSupport();
        blocker.setTaskManager(this);
        this.taskListenerSupport.addListener(new TaskListenerAdapter(){

            @Override
            public void stateChanged(ChangeEvent<Task.State> event) {
                Task.State newState = event.getNewValue();
                String contextId = event.getSource().getContextId();
                Task task = event.getSource().getTask();
                if (newState != null) {
                    if (newState.isFinalState()) {
                        DefaultTaskManager.this.tasks.remove(contextId);
                        if (task.getMode() == Task.Mode.BLOCKING_APPLICATION || task.getMode() == Task.Mode.BLOCKING_WINDOW) {
                            blocker.unblock(task);
                        }
                    }
                    if (newState == Task.State.STARTED && (task.getMode() == Task.Mode.BLOCKING_APPLICATION || task.getMode() == Task.Mode.BLOCKING_WINDOW)) {
                        blocker.block(task);
                    }
                }
            }
        });
        this.executorService = this.createExecutorService();
    }

    protected TaskListenerSupport createTaskListenerSupport() {
        return new DefaultTaskListenerSupport();
    }

    protected ThreadPoolExecutor createExecutorService() {
        return new ThreadPoolExecutor(0, 20, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    @Override
    public <V, C> TaskControl<V> create(Task<V, C> task) {
        TaskContext context = this.createTaskContext(task);
        TaskControl<V> control = this.createTaskControl(context);
        this.tasks.put(control.getContext().getContextId(), control);
        context.fireStateChangeEvent(null, Task.State.PENDING);
        return control;
    }

    protected <V> TaskControl<V> createTaskControl(TaskContext context) {
        return new DefaultTaskControl(context);
    }

    protected <V, C> TaskContext createTaskContext(Task<V, C> task) {
        return new DefaultTaskContext(new DefaultTaskWorker<V, C>(task), this.taskListenerSupport);
    }

    @Override
    public TaskListenerSupport getTaskListenerSupport() {
        return this.taskListenerSupport;
    }

    @Override
    public Iterable<TaskControl> getTasks(TaskPredicate predicate) {
        return TaskIterable.filter(this.tasks.values(), predicate);
    }

    @Override
    public TaskControl findTask(TaskPredicate predicate) {
        return TaskIterable.find(this.tasks.values(), predicate);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executorService.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    @Override
    public TaskControl getTask(String contextId) {
        return this.tasks.get(contextId);
    }
}

