/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.tasks;

import griffon.plugins.tasks.ChangeEvent;
import griffon.plugins.tasks.ExceptionHandler;
import griffon.plugins.tasks.Task;
import griffon.plugins.tasks.TaskListener;
import griffon.plugins.tasks.TaskListenerSupport;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.griffon.runtime.tasks.EventEmitter;
import org.codehaus.griffon.runtime.tasks.LoggingExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskListenerSupport
implements TaskListenerSupport {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskListenerSupport.class);
    private final ExceptionHandler<TaskListener> loggingExceptionHandler = new LoggingExceptionHandler<TaskListener>(log);
    private final Map<String, EventEmitter<TaskListener>> taskListeners = new HashMap<String, EventEmitter<TaskListener>>();
    private final EventEmitter<TaskListener> globalListeners = EventEmitter.newEmitter(TaskListener.class, this.loggingExceptionHandler);

    @Override
    public void addListener(TaskListener listener) {
        if (listener != null) {
            this.globalListeners.addListener(listener);
        }
    }

    @Override
    public void removeListener(TaskListener listener) {
        if (listener != null) {
            this.globalListeners.removeListener(listener);
        }
    }

    @Override
    public void addListener(String taskId, TaskListener listener) {
        if (listener != null) {
            EventEmitter<TaskListener> emitter = this.getTaskListener(taskId);
            emitter.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventEmitter<TaskListener> getTaskListener(String taskId) {
        EventEmitter<TaskListener> emitter;
        Map<String, EventEmitter<TaskListener>> map = this.taskListeners;
        synchronized (map) {
            emitter = this.taskListeners.get(taskId);
        }
        if (emitter == null) {
            emitter = EventEmitter.newEmitter(TaskListener.class, this.loggingExceptionHandler);
            map = this.taskListeners;
            synchronized (map) {
                this.taskListeners.put(taskId, emitter);
            }
        }
        return emitter;
    }

    @Override
    public void removeListener(String taskId, TaskListener listener) {
        if (listener != null) {
            EventEmitter<TaskListener> emitter = this.getTaskListener(taskId);
            emitter.removeListener(listener);
        }
    }

    public EventEmitter<TaskListener> getGlobalListeners() {
        return this.globalListeners;
    }

    @Override
    public void fireStateChanged(ChangeEvent<Task.State> event) {
        Task task = event.getSource().getTask();
        this.getTaskListener(task.getId()).emitter().stateChanged(event);
        this.globalListeners.emitter().stateChanged(event);
    }

    @Override
    public void fireProgressChanged(ChangeEvent<Integer> event) {
        Task task = event.getSource().getTask();
        this.getTaskListener(task.getId()).emitter().progressChanged(event);
        this.globalListeners.emitter().progressChanged(event);
    }

    @Override
    public void firePhaseChanged(ChangeEvent<String> event) {
        Task task = event.getSource().getTask();
        this.getTaskListener(task.getId()).emitter().phaseChanged(event);
        this.globalListeners.emitter().phaseChanged(event);
    }
}

