/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.tasks;

import griffon.plugins.tasks.Task;
import griffon.plugins.tasks.TaskContext;
import griffon.plugins.tasks.TaskControl;
import griffon.plugins.tasks.TaskWorker;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskControl<V>
implements TaskControl<V> {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskControl.class);
    private final TaskContext taskContext;

    public DefaultTaskControl(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    @Override
    public V waitFor() {
        TaskWorker<V, ?> worker = this.getWorker();
        if (this.taskContext.getState() == Task.State.PENDING) {
            worker.execute();
        }
        try {
            return (V)worker.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error executing task!", e);
        }
        catch (CancellationException e) {
            return null;
        }
    }

    private TaskWorker<V, ?> getWorker() {
        return this.taskContext.getWorker();
    }

    @Override
    public void execute() {
        this.getWorker().execute();
    }

    @Override
    public void cancel() {
        log.info("About to cancel task: " + this.getContext().getContextId());
        this.getWorker().cancel(true);
    }

    @Override
    public TaskContext getContext() {
        return this.taskContext;
    }
}

