/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.tasks;

import griffon.plugins.tasks.Task;
import griffon.plugins.tasks.TaskContext;
import griffon.plugins.tasks.TaskListener;
import griffon.plugins.tasks.TaskListenerSupport;
import griffon.plugins.tasks.TaskWorker;
import griffon.util.UIThreadWorker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicLong;
import org.codehaus.griffon.runtime.tasks.DefaultChangeEvent;
import org.codehaus.griffon.runtime.tasks.EventEmitter;
import org.codehaus.griffon.runtime.tasks.LoggingExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskContext
implements TaskContext,
PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskContext.class);
    private static final AtomicLong counter = new AtomicLong(0L);
    private final String contextId = String.valueOf(counter.getAndIncrement());
    private final TaskWorker worker;
    private final TaskListenerSupport taskListenerSupport;
    private final EventEmitter<TaskListener> localListeners = EventEmitter.newEmitter(TaskListener.class, new LoggingExceptionHandler(log));

    public DefaultTaskContext(TaskWorker worker, TaskListenerSupport taskListenerSupport) {
        this.worker = worker;
        this.worker.setContext(this);
        this.taskListenerSupport = taskListenerSupport;
        this.worker.addPropertyChangeListener(this);
    }

    @Override
    public String getContextId() {
        return this.contextId;
    }

    @Override
    public Long getStartedTimestamp() {
        return this.worker.getStartedTimestamp();
    }

    @Override
    public Long getFinishTimestamp() {
        return this.worker.getFinishTimestamp();
    }

    @Override
    public Task.State getState() {
        if (this.worker.isCancelled()) {
            return Task.State.CANCELLED;
        }
        return this.toState((Object)this.worker.getState());
    }

    @Override
    public int getProgress() {
        return this.worker.getProgress();
    }

    @Override
    public String getPhase() {
        return this.worker.getPhase();
    }

    @Override
    public Long getDuration() {
        Long start = this.getStartedTimestamp();
        if (start != null) {
            Long finish = this.getFinishTimestamp();
            long end = finish != null ? finish : System.currentTimeMillis();
            return end - start;
        }
        return null;
    }

    @Override
    public void addListener(TaskListener listener) {
        if (listener != null) {
            this.localListeners.addListener(listener);
        }
    }

    @Override
    public void removeListener(TaskListener listener) {
        if (listener != null) {
            this.localListeners.addListener(listener);
        }
    }

    @Override
    public <V, C> TaskWorker<V, C> getWorker() {
        return this.worker;
    }

    @Override
    public Task getTask() {
        return this.worker.getTask();
    }

    @Override
    public void fireStateChangeEvent(Task.State oldValue, Task.State newValue) {
        DefaultChangeEvent<Task.State> e = new DefaultChangeEvent<Task.State>(oldValue, newValue, this);
        this.taskListenerSupport.fireStateChanged(e);
        this.localListeners.emitter().stateChanged(e);
    }

    @Override
    public void fireProgressChangeEvent(Integer oldValue, Integer newValue) {
        DefaultChangeEvent<Integer> e = new DefaultChangeEvent<Integer>(oldValue, newValue, this);
        this.taskListenerSupport.fireProgressChanged(e);
        this.localListeners.emitter().progressChanged(e);
    }

    @Override
    public void firePhaseChangeEvent(String oldValue, String newValue) {
        DefaultChangeEvent<String> e = new DefaultChangeEvent<String>(oldValue, newValue, this);
        this.taskListenerSupport.firePhaseChanged(e);
        this.localListeners.emitter().phaseChanged(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getTask().getMode() == Task.Mode.SILENT) {
            return;
        }
        if (evt.getPropertyName().equals("state")) {
            UIThreadWorker.StateValue nv = (UIThreadWorker.StateValue)((Object)evt.getNewValue());
            if (nv == UIThreadWorker.StateValue.DONE) {
                if (this.worker.isError()) {
                    this.fireStateChangeEvent(this.toState(evt.getOldValue()), Task.State.FAILED);
                } else if (this.worker.isCancelled()) {
                    this.fireStateChangeEvent(this.toState(evt.getOldValue()), Task.State.CANCELLED);
                } else {
                    this.fireStateChangeEvent(this.toState(evt.getOldValue()), this.toState(evt.getNewValue()));
                }
            } else {
                this.fireStateChangeEvent(this.toState(evt.getOldValue()), this.toState(evt.getNewValue()));
            }
        }
        if (evt.getPropertyName().equals("progress")) {
            this.fireProgressChangeEvent((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
        }
        if (evt.getPropertyName().equals("phase")) {
            this.firePhaseChangeEvent((String)evt.getOldValue(), (String)evt.getNewValue());
        }
    }

    private Task.State toState(Object value) {
        if (value == Task.State.CANCELLED) {
            return (Task.State)((Object)value);
        }
        switch ((UIThreadWorker.StateValue)((Object)value)) {
            case DONE: {
                return Task.State.DONE;
            }
            case PENDING: {
                return Task.State.PENDING;
            }
            case STARTED: {
                return Task.State.STARTED;
            }
        }
        throw new Error("unknown state: " + value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTaskContext that = (DefaultTaskContext)o;
        return !(this.contextId != null ? !this.contextId.equals(that.contextId) : that.contextId != null);
    }

    public int hashCode() {
        return this.contextId != null ? this.contextId.hashCode() : 0;
    }

    public String toString() {
        return "DefaultTaskContext{contextId='" + this.contextId + '\'' + '}';
    }
}

