/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.AbstractCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.autocomplete.TemplatePiece;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class TemplateCompletion
extends AbstractCompletion
implements ParameterizedCompletion {
    private List pieces;
    private String inputText;
    private String definitionString;
    private String shortDescription;
    private String summary;
    private List params;

    public TemplateCompletion(CompletionProvider completionProvider, String string, String string2, String string3) {
        this(completionProvider, string, string2, string3, null, null);
    }

    public TemplateCompletion(CompletionProvider completionProvider, String string, String string2, String string3, String string4, String string5) {
        super(completionProvider);
        this.inputText = string;
        this.definitionString = string2;
        this.shortDescription = string4;
        this.summary = string5;
        this.pieces = new ArrayList(3);
        this.params = new ArrayList(3);
        this.parse(string3);
    }

    private void addTemplatePiece(TemplatePiece templatePiece) {
        this.pieces.add(templatePiece);
        if (templatePiece instanceof TemplatePiece.Param && !"cursor".equals(templatePiece.getText())) {
            Object var2_2 = null;
            ParameterizedCompletion.Parameter parameter = new ParameterizedCompletion.Parameter(var2_2, templatePiece.getText());
            this.params.add(parameter);
        }
    }

    public String getInputText() {
        return this.inputText;
    }

    private String getPieceText(int n, String string) {
        TemplatePiece templatePiece = (TemplatePiece)this.pieces.get(n);
        String string2 = templatePiece.getText();
        if (string2.indexOf(10) > -1) {
            string2 = string2.replaceAll("\n", "\n" + string);
        }
        return string2;
    }

    public String getReplacementText() {
        return null;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDefinitionString() {
        return this.definitionString;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public boolean getShowParameterToolTip() {
        return false;
    }

    public ParameterizedCompletionInsertionInfo getInsertionInfo(JTextComponent jTextComponent, boolean bl, boolean bl2) {
        int n;
        int n2;
        ParameterizedCompletionInsertionInfo parameterizedCompletionInsertionInfo = new ParameterizedCompletionInsertionInfo();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 = jTextComponent.getCaretPosition();
        Position position = null;
        int n4 = -1;
        try {
            position = jTextComponent.getDocument().createPosition(n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        parameterizedCompletionInsertionInfo.setCaretRange(n3, position);
        int n5 = 0;
        int n6 = n = n2;
        Document document = jTextComponent.getDocument();
        String string = null;
        try {
            string = RSyntaxUtilities.getLeadingWhitespace((Document)document, (int)n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            string = "";
        }
        int n7 = n2;
        for (int i = 0; i < this.pieces.size(); ++i) {
            TemplatePiece templatePiece = (TemplatePiece)this.pieces.get(i);
            String string2 = this.getPieceText(i, string);
            if (templatePiece instanceof TemplatePiece.Text) {
                if (bl2) {
                    n7 = this.possiblyReplaceTabsWithSpaces(stringBuffer, string2, jTextComponent, n7);
                    continue;
                }
                stringBuffer.append(string2);
                n7 += string2.length();
                continue;
            }
            if (templatePiece instanceof TemplatePiece.Param && "cursor".equals(string2)) {
                n4 = n7;
                continue;
            }
            int n8 = n7 + string2.length();
            stringBuffer.append(string2);
            if (templatePiece instanceof TemplatePiece.Param) {
                parameterizedCompletionInsertionInfo.addReplacementLocation(n7, n8);
                if (n5 == 0) {
                    n5 = string2.length();
                    n = n7;
                    n6 = n + n5;
                }
            } else if (templatePiece instanceof TemplatePiece.ParamCopy) {
                parameterizedCompletionInsertionInfo.addReplacementCopy(templatePiece.getText(), n7, n8);
            }
            n7 = n8;
        }
        if (n == n3 && n == n6 && this.getParamCount() == 0 && n4 > -1) {
            n = n6 = n4;
        }
        parameterizedCompletionInsertionInfo.setInitialSelection(n, n6);
        if (n4 > -1) {
            parameterizedCompletionInsertionInfo.addReplacementLocation(n4, n4);
        }
        parameterizedCompletionInsertionInfo.setDefaultEndOffs(n4);
        parameterizedCompletionInsertionInfo.setTextToInsert(stringBuffer.toString());
        return parameterizedCompletionInsertionInfo;
    }

    public ParameterizedCompletion.Parameter getParam(int n) {
        return (ParameterizedCompletion.Parameter)this.params.get(n);
    }

    public int getParamCount() {
        return this.params == null ? 0 : this.params.size();
    }

    private boolean isParamDefined(String string) {
        for (int i = 0; i < this.getParamCount(); ++i) {
            ParameterizedCompletion.Parameter parameter = this.getParam(i);
            if (!string.equals(parameter.getName())) continue;
            return true;
        }
        return false;
    }

    private void parse(String string) {
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(36, n2)) > -1 && n < string.length() - 1) {
            char c = string.charAt(n + 1);
            switch (c) {
                case '$': {
                    this.addTemplatePiece(new TemplatePiece.Text(string.substring(n2, n + 1)));
                    n2 = n += 2;
                    break;
                }
                case '{': {
                    int n3 = string.indexOf(125, n + 2);
                    if (n3 <= -1) break;
                    this.addTemplatePiece(new TemplatePiece.Text(string.substring(n2, n)));
                    String string2 = string.substring(n + 2, n3);
                    if (!"cursor".equals(string2) && this.isParamDefined(string2)) {
                        this.addTemplatePiece(new TemplatePiece.ParamCopy(string2));
                    } else {
                        this.addTemplatePiece(new TemplatePiece.Param(string2));
                    }
                    n2 = n = n3 + 1;
                }
            }
        }
        if (n2 < string.length()) {
            String string3 = string.substring(n2);
            this.addTemplatePiece(new TemplatePiece.Text(string3));
        }
    }

    private int possiblyReplaceTabsWithSpaces(StringBuffer stringBuffer, String string, JTextComponent jTextComponent, int n) {
        int n2 = string.indexOf(9);
        if (n2 > -1) {
            int n3;
            Object object;
            int n4 = stringBuffer.length();
            int n5 = 4;
            Document document = jTextComponent.getDocument();
            if (document != null && (object = (Integer)document.getProperty("tabSize")) != null) {
                n5 = (Integer)object;
            }
            object = "";
            for (n3 = 0; n3 < n5; ++n3) {
                object = (String)object + " ";
            }
            n3 = 0;
            do {
                stringBuffer.append(string.substring(n3, n2));
                stringBuffer.append((String)object);
            } while ((n2 = string.indexOf(9, n3 = n2 + 1)) > -1);
            stringBuffer.append(string.substring(n3));
            n += stringBuffer.length() - n4;
        } else {
            stringBuffer.append(string);
            n += string.length();
        }
        return n;
    }

    public String toString() {
        return this.getDefinitionString();
    }
}

