/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.AutoCompletionStyleContext;
import org.fife.ui.autocomplete.OutlineHighlightPainter;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionChoicesWindow;
import org.fife.ui.autocomplete.ParameterizedCompletionDescriptionToolTip;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;

class ParameterizedCompletionContext {
    private Window parentWindow;
    private AutoCompletion ac;
    private ParameterizedCompletion pc;
    private boolean active;
    private ParameterizedCompletionDescriptionToolTip tip;
    private Highlighter.HighlightPainter p;
    private Highlighter.HighlightPainter endingP;
    private Highlighter.HighlightPainter paramCopyP;
    private List tags;
    private List paramCopyInfos;
    private transient boolean ignoringDocumentEvents;
    private Listener listener;
    private int minPos;
    private Position maxPos;
    private Position defaultEndOffs;
    private int lastSelectedParam;
    private ParameterizedCompletionChoicesWindow paramChoicesWindow;
    private String paramPrefix;
    private Object oldTabKey;
    private Action oldTabAction;
    private Object oldShiftTabKey;
    private Action oldShiftTabAction;
    private Object oldUpKey;
    private Action oldUpAction;
    private Object oldDownKey;
    private Action oldDownAction;
    private Object oldEnterKey;
    private Action oldEnterAction;
    private Object oldEscapeKey;
    private Action oldEscapeAction;
    private Object oldClosingKey;
    private Action oldClosingAction;
    private static final String IM_KEY_TAB = "ParamCompKey.Tab";
    private static final String IM_KEY_SHIFT_TAB = "ParamCompKey.ShiftTab";
    private static final String IM_KEY_UP = "ParamCompKey.Up";
    private static final String IM_KEY_DOWN = "ParamCompKey.Down";
    private static final String IM_KEY_ESCAPE = "ParamCompKey.Escape";
    private static final String IM_KEY_ENTER = "ParamCompKey.Enter";
    private static final String IM_KEY_CLOSING = "ParamCompKey.Closing";

    public ParameterizedCompletionContext(Window window, AutoCompletion autoCompletion, ParameterizedCompletion parameterizedCompletion) {
        this.parentWindow = window;
        this.ac = autoCompletion;
        this.pc = parameterizedCompletion;
        this.listener = new Listener();
        AutoCompletionStyleContext autoCompletionStyleContext = AutoCompletion.getStyleContext();
        this.p = new OutlineHighlightPainter(autoCompletionStyleContext.getParameterOutlineColor());
        this.endingP = new OutlineHighlightPainter(autoCompletionStyleContext.getParameterizedCompletionCursorPositionColor());
        this.paramCopyP = new ChangeableHighlightPainter((Paint)autoCompletionStyleContext.getParameterCopyColor());
        this.tags = new ArrayList(1);
        this.paramCopyInfos = new ArrayList(1);
    }

    public void activate(boolean bl) {
        if (this.active) {
            return;
        }
        this.active = true;
        JTextComponent jTextComponent = this.ac.getTextComponent();
        this.lastSelectedParam = -1;
        if (this.pc.getShowParameterToolTip()) {
            this.tip = new ParameterizedCompletionDescriptionToolTip(this.parentWindow, this, this.ac, this.pc);
            try {
                int n = jTextComponent.getCaretPosition();
                Rectangle rectangle = jTextComponent.modelToView(n);
                Point point = new Point(rectangle.x, rectangle.y);
                SwingUtilities.convertPointToScreen(point, jTextComponent);
                rectangle.x = point.x;
                rectangle.y = point.y;
                this.tip.setLocationRelativeTo(rectangle);
                this.tip.setVisible(true);
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                badLocationException.printStackTrace();
                this.tip = null;
            }
        }
        this.listener.install(jTextComponent, bl);
        if (this.paramChoicesWindow == null) {
            this.paramChoicesWindow = this.createParamChoicesWindow();
        }
        this.lastSelectedParam = this.getCurrentParameterIndex();
        this.prepareParamChoicesWindow();
        this.paramChoicesWindow.setVisible(true);
    }

    private ParameterizedCompletionChoicesWindow createParamChoicesWindow() {
        ParameterizedCompletionChoicesWindow parameterizedCompletionChoicesWindow = new ParameterizedCompletionChoicesWindow(this.parentWindow, this.ac, this);
        parameterizedCompletionChoicesWindow.initialize(this.pc);
        return parameterizedCompletionChoicesWindow;
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.listener.uninstall();
        if (this.tip != null) {
            this.tip.setVisible(false);
        }
        if (this.paramChoicesWindow != null) {
            this.paramChoicesWindow.setVisible(false);
        }
    }

    public String getArgumentText(int n) {
        List list = this.getParameterHighlights();
        if (list == null || list.size() == 0) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            Highlighter.Highlight highlight = (Highlighter.Highlight)list.get(i);
            if (n < highlight.getStartOffset() || n > highlight.getEndOffset()) continue;
            int n2 = highlight.getStartOffset() + 1;
            int n3 = highlight.getEndOffset() - n2;
            JTextComponent jTextComponent = this.ac.getTextComponent();
            Document document = jTextComponent.getDocument();
            try {
                return document.getText(n2, n3);
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                badLocationException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private Highlighter.Highlight getCurrentParameterHighlight() {
        JTextComponent jTextComponent = this.ac.getTextComponent();
        int n = jTextComponent.getCaretPosition();
        if (n > 0) {
            --n;
        }
        List list = this.getParameterHighlights();
        for (int i = 0; i < list.size(); ++i) {
            Highlighter.Highlight highlight = (Highlighter.Highlight)list.get(i);
            if (n < highlight.getStartOffset() || n >= highlight.getEndOffset()) continue;
            return highlight;
        }
        return null;
    }

    private int getCurrentParameterIndex() {
        JTextComponent jTextComponent = this.ac.getTextComponent();
        int n = jTextComponent.getCaretPosition();
        if (n > 0) {
            --n;
        }
        List list = this.getParameterHighlights();
        for (int i = 0; i < list.size(); ++i) {
            Highlighter.Highlight highlight = (Highlighter.Highlight)list.get(i);
            if (n < highlight.getStartOffset() || n >= highlight.getEndOffset()) continue;
            return i;
        }
        return -1;
    }

    private int getCurrentParameterStartOffset() {
        Highlighter.Highlight highlight = this.getCurrentParameterHighlight();
        return highlight != null ? highlight.getStartOffset() + 1 : -1;
    }

    private static final int getFirstHighlight(List list) {
        int n = -1;
        Highlighter.Highlight highlight = null;
        for (int i = 0; i < list.size(); ++i) {
            Highlighter.Highlight highlight2 = (Highlighter.Highlight)list.get(i);
            if (highlight != null && highlight2.getStartOffset() >= highlight.getStartOffset()) continue;
            highlight = highlight2;
            n = i;
        }
        return n;
    }

    private static final int getLastHighlight(List list) {
        int n = -1;
        Highlighter.Highlight highlight = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            Highlighter.Highlight highlight2 = (Highlighter.Highlight)list.get(i);
            if (highlight != null && highlight2.getStartOffset() <= highlight.getStartOffset()) continue;
            highlight = highlight2;
            n = i;
        }
        return n;
    }

    public List getParameterHighlights() {
        ArrayList<Highlighter.Highlight> arrayList = new ArrayList<Highlighter.Highlight>(2);
        JTextComponent jTextComponent = this.ac.getTextComponent();
        Highlighter.Highlight[] highlightArray = jTextComponent.getHighlighter().getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            Highlighter.HighlightPainter highlightPainter = highlightArray[i].getPainter();
            if (highlightPainter != this.p && highlightPainter != this.endingP) continue;
            arrayList.add(highlightArray[i]);
        }
        return arrayList;
    }

    boolean insertSelectedChoice() {
        String string;
        if (this.paramChoicesWindow != null && this.paramChoicesWindow.isVisible() && (string = this.paramChoicesWindow.getSelectedChoice()) != null) {
            JTextComponent jTextComponent = this.ac.getTextComponent();
            Highlighter.Highlight highlight = this.getCurrentParameterHighlight();
            if (highlight != null) {
                jTextComponent.setSelectionStart(highlight.getStartOffset() + 1);
                jTextComponent.setSelectionEnd(highlight.getEndOffset());
                jTextComponent.replaceSelection(string);
                this.moveToNextParam();
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
            }
            return true;
        }
        return false;
    }

    private void installKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("CompletionContext: Installing keybindings");
        }
        JTextComponent jTextComponent = this.ac.getTextComponent();
        InputMap inputMap = jTextComponent.getInputMap();
        ActionMap actionMap = jTextComponent.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        this.oldTabKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_TAB);
        this.oldTabAction = actionMap.get(IM_KEY_TAB);
        actionMap.put(IM_KEY_TAB, new NextParamAction());
        keyStroke = KeyStroke.getKeyStroke(9, 1);
        this.oldShiftTabKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_SHIFT_TAB);
        this.oldShiftTabAction = actionMap.get(IM_KEY_SHIFT_TAB);
        actionMap.put(IM_KEY_SHIFT_TAB, new PrevParamAction());
        keyStroke = KeyStroke.getKeyStroke(38, 0);
        this.oldUpKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_UP);
        this.oldUpAction = actionMap.get(IM_KEY_UP);
        actionMap.put(IM_KEY_UP, new NextChoiceAction(-1, this.oldUpAction));
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        this.oldDownKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_DOWN);
        this.oldDownAction = actionMap.get(IM_KEY_DOWN);
        actionMap.put(IM_KEY_DOWN, new NextChoiceAction(1, this.oldDownAction));
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.oldEnterKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_ENTER);
        this.oldEnterAction = actionMap.get(IM_KEY_ENTER);
        actionMap.put(IM_KEY_ENTER, new GotoEndAction());
        keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.oldEscapeKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_ESCAPE);
        this.oldEscapeAction = actionMap.get(IM_KEY_ESCAPE);
        actionMap.put(IM_KEY_ESCAPE, new HideAction());
        char c = this.pc.getProvider().getParameterListEnd();
        keyStroke = KeyStroke.getKeyStroke(c);
        this.oldClosingKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, IM_KEY_CLOSING);
        this.oldClosingAction = actionMap.get(IM_KEY_CLOSING);
        actionMap.put(IM_KEY_CLOSING, new ClosingAction());
    }

    private void moveToNextParam() {
        int n;
        JTextComponent jTextComponent = this.ac.getTextComponent();
        int n2 = jTextComponent.getCaretPosition();
        int n3 = this.tags.size();
        if (n3 == 0) {
            jTextComponent.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
        Highlighter.Highlight highlight = null;
        int n4 = -1;
        List list = this.getParameterHighlights();
        for (n = 0; n < list.size(); ++n) {
            Highlighter.Highlight highlight2 = (Highlighter.Highlight)list.get(n);
            if (highlight != null && highlight.getStartOffset() >= n2 && (highlight2.getStartOffset() <= n2 || highlight2.getStartOffset() > highlight.getStartOffset())) continue;
            highlight = highlight2;
            n4 = n;
        }
        if (highlight.getStartOffset() + 1 <= n2) {
            n = ParameterizedCompletionContext.getFirstHighlight(list);
            highlight = (Highlighter.Highlight)list.get(n);
            n4 = 0;
        }
        jTextComponent.setSelectionStart(highlight.getStartOffset() + 1);
        jTextComponent.setSelectionEnd(highlight.getEndOffset());
        this.updateToolTipText(n4);
    }

    private void moveToPreviousParam() {
        int n;
        JTextComponent jTextComponent = this.ac.getTextComponent();
        int n2 = this.tags.size();
        if (n2 == 0) {
            jTextComponent.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
        int n3 = jTextComponent.getCaretPosition();
        int n4 = jTextComponent.getSelectionStart() - 1;
        Highlighter.Highlight highlight = null;
        int n5 = 0;
        List list = this.getParameterHighlights();
        for (n = 0; n < list.size(); ++n) {
            Highlighter.Highlight highlight2 = (Highlighter.Highlight)list.get(n);
            if (highlight != null && highlight.getStartOffset() < n3 && (highlight2.getStartOffset() >= n4 || highlight2.getStartOffset() <= highlight.getStartOffset() && n5 != this.lastSelectedParam)) continue;
            highlight = highlight2;
            n5 = n;
        }
        n = ParameterizedCompletionContext.getFirstHighlight(list);
        if (n5 == n && this.lastSelectedParam == n && list.size() > 1) {
            n5 = ParameterizedCompletionContext.getLastHighlight(list);
            highlight = (Highlighter.Highlight)list.get(n5);
            jTextComponent.setSelectionStart(highlight.getStartOffset() + 1);
            jTextComponent.setSelectionEnd(highlight.getEndOffset());
            this.updateToolTipText(n5);
        } else if (highlight != null && n3 > highlight.getStartOffset()) {
            jTextComponent.setSelectionStart(highlight.getStartOffset() + 1);
            jTextComponent.setSelectionEnd(highlight.getEndOffset());
            this.updateToolTipText(n5);
        } else {
            jTextComponent.setCaretPosition(this.maxPos.getOffset());
            this.deactivate();
        }
    }

    private void possiblyUpdateParamCopies(Document document) {
        int n = this.getCurrentParameterIndex();
        if (n > -1 && n < this.pc.getParamCount()) {
            ParameterizedCompletion.Parameter parameter = this.pc.getParam(n);
            if (parameter.isEndParam()) {
                this.deactivate();
                return;
            }
            List list = this.getParameterHighlights();
            Highlighter.Highlight highlight = (Highlighter.Highlight)list.get(n);
            int n2 = highlight.getStartOffset() + 1;
            int n3 = highlight.getEndOffset() - n2;
            String string = null;
            try {
                string = document.getText(n2, n3);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            Iterator iterator = this.paramCopyInfos.iterator();
            while (iterator.hasNext()) {
                ParamCopyInfo paramCopyInfo = (ParamCopyInfo)iterator.next();
                if (!paramCopyInfo.paramName.equals(parameter.getName())) continue;
                paramCopyInfo.h = this.replaceHighlightedText(document, paramCopyInfo.h, string);
            }
        } else {
            this.deactivate();
        }
    }

    private void prepareParamChoicesWindow() {
        if (this.paramChoicesWindow != null) {
            int n = this.getCurrentParameterStartOffset();
            if (n == -1) {
                this.paramChoicesWindow.setVisible(false);
                return;
            }
            JTextComponent jTextComponent = this.ac.getTextComponent();
            try {
                Rectangle rectangle = jTextComponent.modelToView(n);
                Point point = new Point(rectangle.x, rectangle.y);
                SwingUtilities.convertPointToScreen(point, jTextComponent);
                rectangle.x = point.x;
                rectangle.y = point.y;
                this.paramChoicesWindow.setLocationRelativeTo(rectangle);
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                badLocationException.printStackTrace();
            }
            this.paramChoicesWindow.setParameter(this.lastSelectedParam, this.paramPrefix);
        }
    }

    private void removeParameterHighlights() {
        int n;
        JTextComponent jTextComponent = this.ac.getTextComponent();
        Highlighter highlighter = jTextComponent.getHighlighter();
        for (n = 0; n < this.tags.size(); ++n) {
            highlighter.removeHighlight(this.tags.get(n));
        }
        this.tags.clear();
        for (n = 0; n < this.paramCopyInfos.size(); ++n) {
            ParamCopyInfo paramCopyInfo = (ParamCopyInfo)this.paramCopyInfos.get(n);
            highlighter.removeHighlight(paramCopyInfo.h);
        }
        this.paramCopyInfos.clear();
    }

    private Highlighter.Highlight replaceHighlightedText(Document document, Highlighter.Highlight highlight, String string) {
        try {
            int n = highlight.getStartOffset();
            int n2 = highlight.getEndOffset() - n;
            Highlighter highlighter = this.ac.getTextComponent().getHighlighter();
            highlighter.removeHighlight(highlight);
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).replace(n, n2, string, null);
            } else {
                document.remove(n, n2);
                document.insertString(n, string, null);
            }
            int n3 = n + string.length();
            highlight = (Highlighter.Highlight)highlighter.addHighlight(n, n3, this.paramCopyP);
            return highlight;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    private void uninstallKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("CompletionContext Uninstalling keybindings");
        }
        JTextComponent jTextComponent = this.ac.getTextComponent();
        InputMap inputMap = jTextComponent.getInputMap();
        ActionMap actionMap = jTextComponent.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        inputMap.put(keyStroke, this.oldTabKey);
        actionMap.put(IM_KEY_TAB, this.oldTabAction);
        keyStroke = KeyStroke.getKeyStroke(9, 1);
        inputMap.put(keyStroke, this.oldShiftTabKey);
        actionMap.put(IM_KEY_SHIFT_TAB, this.oldShiftTabAction);
        keyStroke = KeyStroke.getKeyStroke(38, 0);
        inputMap.put(keyStroke, this.oldUpKey);
        actionMap.put(IM_KEY_UP, this.oldUpAction);
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        inputMap.put(keyStroke, this.oldDownKey);
        actionMap.put(IM_KEY_DOWN, this.oldDownAction);
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        inputMap.put(keyStroke, this.oldEnterKey);
        actionMap.put(IM_KEY_ENTER, this.oldEnterAction);
        keyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke, this.oldEscapeKey);
        actionMap.put(IM_KEY_ESCAPE, this.oldEscapeAction);
        char c = this.pc.getProvider().getParameterListEnd();
        keyStroke = KeyStroke.getKeyStroke(c);
        inputMap.put(keyStroke, this.oldClosingKey);
        actionMap.put(IM_KEY_CLOSING, this.oldClosingAction);
    }

    private String updateToolTipText() {
        JTextComponent jTextComponent = this.ac.getTextComponent();
        int n = jTextComponent.getSelectionStart();
        int n2 = jTextComponent.getSelectionEnd();
        int n3 = -1;
        String string = null;
        List list = this.getParameterHighlights();
        for (int i = 0; i < list.size(); ++i) {
            Highlighter.Highlight highlight = (Highlighter.Highlight)list.get(i);
            int n4 = highlight.getStartOffset() + 1;
            if (n < n4 || n > highlight.getEndOffset()) continue;
            try {
                if (n != n4 || n2 != highlight.getEndOffset()) {
                    string = jTextComponent.getText(n4, n - n4);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            n3 = i;
            break;
        }
        this.updateToolTipText(n3);
        return string;
    }

    private void updateToolTipText(int n) {
        if (n != this.lastSelectedParam) {
            if (this.tip != null) {
                this.tip.updateText(n);
            }
            this.lastSelectedParam = n;
        }
    }

    public void updateUI() {
        if (this.tip != null) {
            this.tip.updateUI();
        }
        if (this.paramChoicesWindow != null) {
            this.paramChoicesWindow.updateUI();
        }
    }

    private class PrevParamAction
    extends AbstractAction {
        private PrevParamAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ParameterizedCompletionContext.this.moveToPreviousParam();
        }
    }

    private static class ParamCopyInfo {
        private String paramName;
        private Highlighter.Highlight h;

        public ParamCopyInfo(String string, Highlighter.Highlight highlight) {
            this.paramName = string;
            this.h = highlight;
        }
    }

    private class NextParamAction
    extends AbstractAction {
        private NextParamAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ParameterizedCompletionContext.this.moveToNextParam();
        }
    }

    private class NextChoiceAction
    extends AbstractAction {
        private Action oldAction;
        private int amount;

        public NextChoiceAction(int n, Action action) {
            this.amount = n;
            this.oldAction = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible()) {
                ParameterizedCompletionContext.this.paramChoicesWindow.incSelection(this.amount);
            } else if (this.oldAction != null) {
                this.oldAction.actionPerformed(actionEvent);
            } else {
                ParameterizedCompletionContext.this.deactivate();
            }
        }
    }

    private class Listener
    implements FocusListener,
    CaretListener,
    DocumentListener {
        private boolean markOccurrencesEnabled;

        private Listener() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (ParameterizedCompletionContext.this.maxPos == null) {
                ParameterizedCompletionContext.this.deactivate();
                return;
            }
            int n = caretEvent.getDot();
            if (n < ParameterizedCompletionContext.this.minPos || n > ParameterizedCompletionContext.this.maxPos.getOffset()) {
                ParameterizedCompletionContext.this.deactivate();
                return;
            }
            ParameterizedCompletionContext.this.paramPrefix = ParameterizedCompletionContext.this.updateToolTipText();
            if (ParameterizedCompletionContext.this.active) {
                ParameterizedCompletionContext.this.prepareParamChoicesWindow();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            ParameterizedCompletionContext.this.deactivate();
        }

        private void handleDocumentEvent(final DocumentEvent documentEvent) {
            if (!ParameterizedCompletionContext.this.ignoringDocumentEvents) {
                ParameterizedCompletionContext.this.ignoringDocumentEvents = true;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ParameterizedCompletionContext.this.possiblyUpdateParamCopies(documentEvent.getDocument());
                        ParameterizedCompletionContext.this.ignoringDocumentEvents = false;
                    }
                });
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        public void install(JTextComponent jTextComponent, boolean bl) {
            Object object;
            boolean bl2 = false;
            if (jTextComponent instanceof RSyntaxTextArea) {
                object = (RSyntaxTextArea)jTextComponent;
                this.markOccurrencesEnabled = object.getMarkOccurrences();
                object.setMarkOccurrences(false);
                bl2 = object.getTabsEmulated();
            }
            object = jTextComponent.getHighlighter();
            try {
                Object object2;
                int n;
                ParameterizedCompletionInsertionInfo parameterizedCompletionInsertionInfo = ParameterizedCompletionContext.this.pc.getInsertionInfo(jTextComponent, bl, bl2);
                jTextComponent.replaceSelection(parameterizedCompletionInsertionInfo.getTextToInsert());
                int n2 = parameterizedCompletionInsertionInfo.getReplacementCount();
                for (n = 0; n < n2; ++n) {
                    object2 = parameterizedCompletionInsertionInfo.getReplacementLocation(n);
                    Highlighter.HighlightPainter highlightPainter = n < n2 - 1 ? ParameterizedCompletionContext.this.p : ParameterizedCompletionContext.this.endingP;
                    ParameterizedCompletionContext.this.tags.add(object.addHighlight(object2.getStartOffset() - 1, object2.getEndOffset(), highlightPainter));
                }
                for (n = 0; n < parameterizedCompletionInsertionInfo.getReplacementCopyCount(); ++n) {
                    object2 = parameterizedCompletionInsertionInfo.getReplacementCopy(n);
                    ParameterizedCompletionContext.this.paramCopyInfos.add(new ParamCopyInfo(((ParameterizedCompletionInsertionInfo.ReplacementCopy)object2).getId(), (Highlighter.Highlight)object.addHighlight(((ParameterizedCompletionInsertionInfo.ReplacementCopy)object2).getStart(), ((ParameterizedCompletionInsertionInfo.ReplacementCopy)object2).getEnd(), ParameterizedCompletionContext.this.paramCopyP)));
                }
                jTextComponent.setCaretPosition(parameterizedCompletionInsertionInfo.getSelectionStart());
                if (parameterizedCompletionInsertionInfo.hasSelection()) {
                    jTextComponent.moveCaretPosition(parameterizedCompletionInsertionInfo.getSelectionEnd());
                }
                ParameterizedCompletionContext.this.minPos = parameterizedCompletionInsertionInfo.getMinOffset();
                ParameterizedCompletionContext.this.maxPos = parameterizedCompletionInsertionInfo.getMaxOffset();
                try {
                    ParameterizedCompletionContext.this.defaultEndOffs = jTextComponent.getDocument().createPosition(parameterizedCompletionInsertionInfo.getDefaultEndOffs());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                jTextComponent.getDocument().addDocumentListener(this);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            jTextComponent.addCaretListener(this);
            jTextComponent.addFocusListener(this);
            ParameterizedCompletionContext.this.installKeyBindings();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        public void uninstall() {
            JTextComponent jTextComponent = ParameterizedCompletionContext.this.ac.getTextComponent();
            jTextComponent.removeCaretListener(this);
            jTextComponent.removeFocusListener(this);
            jTextComponent.getDocument().removeDocumentListener(this);
            ParameterizedCompletionContext.this.uninstallKeyBindings();
            if (this.markOccurrencesEnabled) {
                ((RSyntaxTextArea)jTextComponent).setMarkOccurrences(this.markOccurrencesEnabled);
            }
            ParameterizedCompletionContext.this.maxPos = null;
            ParameterizedCompletionContext.this.minPos = -1;
            ParameterizedCompletionContext.this.removeParameterHighlights();
        }
    }

    private class HideAction
    extends AbstractAction {
        private HideAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible()) {
                ParameterizedCompletionContext.this.paramChoicesWindow.setVisible(false);
                ParameterizedCompletionContext.this.paramChoicesWindow = null;
            } else {
                ParameterizedCompletionContext.this.deactivate();
            }
        }
    }

    private class ClosingAction
    extends AbstractAction {
        private ClosingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = ParameterizedCompletionContext.this.ac.getTextComponent();
            int n = jTextComponent.getCaretPosition();
            char c = ParameterizedCompletionContext.this.pc.getProvider().getParameterListEnd();
            if (n >= ParameterizedCompletionContext.this.maxPos.getOffset() - 2) {
                if (n == ParameterizedCompletionContext.this.maxPos.getOffset() - 1) {
                    jTextComponent.replaceSelection(Character.toString(c));
                } else {
                    int n2;
                    char c2;
                    int n3;
                    String string = ParameterizedCompletionContext.this.getArgumentText(n);
                    if (string != null && (n3 = this.getCount(string, c2 = ParameterizedCompletionContext.this.pc.getProvider().getParameterListStart())) > (n2 = this.getCount(string, c))) {
                        jTextComponent.replaceSelection(Character.toString(c));
                        return;
                    }
                    jTextComponent.setCaretPosition(jTextComponent.getCaretPosition() + 1);
                }
                ParameterizedCompletionContext.this.deactivate();
            } else {
                jTextComponent.replaceSelection(Character.toString(c));
            }
        }

        public int getCount(String string, char c) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while ((n3 = string.indexOf(c, n2)) > -1) {
                ++n;
                n2 = n3 + 1;
            }
            return n;
        }
    }

    private class GotoEndAction
    extends AbstractAction {
        private GotoEndAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ParameterizedCompletionContext.this.paramChoicesWindow != null && ParameterizedCompletionContext.this.paramChoicesWindow.isVisible() && ParameterizedCompletionContext.this.insertSelectedChoice()) {
                return;
            }
            ParameterizedCompletionContext.this.deactivate();
            JTextComponent jTextComponent = ParameterizedCompletionContext.this.ac.getTextComponent();
            int n = jTextComponent.getCaretPosition();
            if (n != ParameterizedCompletionContext.this.defaultEndOffs.getOffset()) {
                jTextComponent.setCaretPosition(ParameterizedCompletionContext.this.defaultEndOffs.getOffset());
            } else {
                Action action = this.getDefaultEnterAction(jTextComponent);
                if (action != null) {
                    action.actionPerformed(actionEvent);
                } else {
                    jTextComponent.replaceSelection("\n");
                }
            }
        }

        private Action getDefaultEnterAction(JTextComponent jTextComponent) {
            ActionMap actionMap = jTextComponent.getActionMap();
            return actionMap.get("insert-break");
        }
    }
}

