/*
 * Decompiled with CFR 0.152.
 */
package org.fife.com.swabunga.spell.event;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.fife.com.swabunga.spell.engine.Configuration;
import org.fife.com.swabunga.spell.engine.SpellDictionary;
import org.fife.com.swabunga.spell.engine.SpellDictionaryHashMap;
import org.fife.com.swabunga.spell.engine.Word;
import org.fife.com.swabunga.spell.event.BasicSpellCheckEvent;
import org.fife.com.swabunga.spell.event.SpellCheckEvent;
import org.fife.com.swabunga.spell.event.SpellCheckListener;
import org.fife.com.swabunga.spell.event.StringWordTokenizer;
import org.fife.com.swabunga.spell.event.WordTokenizer;
import org.fife.com.swabunga.util.VectorUtility;

public class SpellChecker {
    public static final int SPELLCHECK_OK = -1;
    public static final int SPELLCHECK_CANCEL = -2;
    private Vector eventListeners = new Vector();
    private Vector dictionaries = new Vector();
    private SpellDictionary userdictionary;
    private Configuration config = Configuration.getConfiguration();
    private Vector ignoredWords = new Vector();
    private Hashtable autoReplaceWords = new Hashtable();
    private Map cache;
    private int threshold = 0;
    private int cacheSize = 0;

    public SpellChecker() {
        try {
            this.userdictionary = new SpellDictionaryHashMap();
        }
        catch (IOException iOException) {
            throw new RuntimeException("this exception should never happen because we are using null phonetic file");
        }
    }

    public SpellChecker(SpellDictionary spellDictionary) {
        this();
        this.addDictionary(spellDictionary);
    }

    public SpellChecker(SpellDictionary spellDictionary, int n) {
        this(spellDictionary);
        this.config.setInteger("SPELL_THRESHOLD", n);
    }

    public void addDictionary(SpellDictionary spellDictionary) {
        if (spellDictionary == null) {
            throw new IllegalArgumentException("dictionary must be non-null");
        }
        this.dictionaries.addElement(spellDictionary);
    }

    public void setUserDictionary(SpellDictionary spellDictionary) {
        this.userdictionary = spellDictionary;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void addSpellCheckListener(SpellCheckListener spellCheckListener) {
        this.eventListeners.addElement(spellCheckListener);
    }

    public void removeSpellCheckListener(SpellCheckListener spellCheckListener) {
        this.eventListeners.removeElement(spellCheckListener);
    }

    protected void fireSpellCheckEvent(SpellCheckEvent spellCheckEvent) {
        for (int i = this.eventListeners.size() - 1; i >= 0; --i) {
            ((SpellCheckListener)this.eventListeners.elementAt(i)).spellingError(spellCheckEvent);
        }
    }

    public void reset() {
        this.ignoredWords = new Vector();
        this.autoReplaceWords = new Hashtable();
    }

    public String checkString(String string) {
        StringWordTokenizer stringWordTokenizer = new StringWordTokenizer(string);
        this.checkSpelling(stringWordTokenizer);
        return stringWordTokenizer.getContext();
    }

    private static final boolean isDigitWord(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static final boolean beginsAsINETWord(String string) {
        int n = Math.min(8, string.length());
        String string2 = string.substring(0, n);
        return string2.startsWith("http://") || string2.startsWith("www.") || string2.startsWith("ftp://") || string2.startsWith("https://") || string2.startsWith("ftps://");
    }

    public static final boolean isINETWord(String string) {
        return SpellChecker.beginsAsINETWord(string) || string.indexOf(64) > 0;
    }

    private static final boolean isUpperCaseWord(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (!Character.isLowerCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final boolean isMixedCaseWord(String string, boolean bl) {
        int n = string.length();
        boolean bl2 = Character.isUpperCase(string.charAt(0));
        if (bl && bl2 && n > 1) {
            bl2 = Character.isUpperCase(string.charAt(1));
        }
        if (bl2) {
            for (int i = string.length() - 1; i > 0; --i) {
                if (!Character.isLowerCase(string.charAt(i))) continue;
                return true;
            }
        } else {
            for (int i = string.length() - 1; i > 0; --i) {
                if (!Character.isUpperCase(string.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean fireAndHandleEvent(WordTokenizer wordTokenizer, SpellCheckEvent spellCheckEvent) {
        this.fireSpellCheckEvent(spellCheckEvent);
        String string = spellCheckEvent.getInvalidWord();
        switch (spellCheckEvent.getAction()) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                this.ignoreAll(string);
                break;
            }
            case 2: {
                wordTokenizer.replaceWord(spellCheckEvent.getReplaceWord());
                break;
            }
            case 3: {
                String string2 = spellCheckEvent.getReplaceWord();
                if (!this.autoReplaceWords.containsKey(string)) {
                    this.autoReplaceWords.put(string, string2);
                }
                wordTokenizer.replaceWord(string2);
                break;
            }
            case 4: {
                String string3 = spellCheckEvent.getReplaceWord();
                if (!string3.equals(string)) {
                    wordTokenizer.replaceWord(string3);
                }
                this.userdictionary.addWord(string3);
                break;
            }
            case 5: {
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unhandled case.");
            }
        }
        return false;
    }

    public void ignoreAll(String string) {
        if (!this.ignoredWords.contains(string)) {
            this.ignoredWords.addElement(string);
        }
    }

    public boolean addToDictionary(String string) {
        if (!this.userdictionary.isCorrect(string)) {
            return this.userdictionary.addWord(string);
        }
        return false;
    }

    public boolean isIgnored(String string) {
        return this.ignoredWords.contains(string);
    }

    public boolean isCorrect(String string) {
        if (this.userdictionary.isCorrect(string)) {
            return true;
        }
        Enumeration enumeration = this.dictionaries.elements();
        while (enumeration.hasMoreElements()) {
            SpellDictionary spellDictionary = (SpellDictionary)enumeration.nextElement();
            if (!spellDictionary.isCorrect(string)) continue;
            return true;
        }
        return false;
    }

    public List getSuggestions(String string, int n) {
        if (this.threshold != n && this.cache != null) {
            this.threshold = n;
            this.cache.clear();
        }
        ArrayList arrayList = null;
        if (this.cache != null) {
            arrayList = (ArrayList)this.cache.get(string);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
            Enumeration enumeration = this.dictionaries.elements();
            while (enumeration.hasMoreElements()) {
                SpellDictionary spellDictionary = (SpellDictionary)enumeration.nextElement();
                if (spellDictionary == this.userdictionary) continue;
                VectorUtility.addAll(arrayList, spellDictionary.getSuggestions(string, n), false);
            }
            if (this.cache != null && this.cache.size() < this.cacheSize) {
                this.cache.put(string, arrayList);
            }
        }
        VectorUtility.addAll(arrayList, this.userdictionary.getSuggestions(string, n), false);
        arrayList.trimToSize();
        return arrayList;
    }

    public void setCache() {
        this.setCache(300);
    }

    public void setCache(int n) {
        this.cacheSize = n;
        this.cache = n == 0 ? null : new HashMap((n + 2) / 3 * 4);
    }

    public final int checkSpelling(WordTokenizer wordTokenizer) {
        int n = 0;
        boolean bl = false;
        while (wordTokenizer.hasMoreWords() && !bl) {
            Object object;
            StringBuffer stringBuffer;
            String string = wordTokenizer.nextWord();
            if (!this.isCorrect(string)) {
                if (this.config.getBoolean("SPELL_IGNOREMIXEDCASE") && SpellChecker.isMixedCaseWord(string, wordTokenizer.isNewSentence()) || this.config.getBoolean("SPELL_IGNOREUPPERCASE") && SpellChecker.isUpperCaseWord(string) || this.config.getBoolean("SPELL_IGNORESINGLELETTERS") && string.length() == 1 || this.config.getBoolean("SPELL_IGNOREDIGITWORDS") && SpellChecker.isDigitWord(string) || this.config.getBoolean("SPELL_IGNOREINTERNETADDRESS") && SpellChecker.isINETWord(string) || this.isIgnored(string)) continue;
                ++n;
                if (this.autoReplaceWords.containsKey(string)) {
                    wordTokenizer.replaceWord((String)this.autoReplaceWords.get(string));
                    continue;
                }
                stringBuffer = null;
                object = new BasicSpellCheckEvent(string, (List)((Object)stringBuffer), wordTokenizer);
                bl = this.fireAndHandleEvent(wordTokenizer, (SpellCheckEvent)object);
                continue;
            }
            if (!this.isSupposedToBeCapitalized(string, wordTokenizer)) continue;
            ++n;
            stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(0, Character.toUpperCase(string.charAt(0)));
            object = new Vector<Word>();
            ((Vector)object).addElement(new Word(stringBuffer.toString(), 0));
            BasicSpellCheckEvent basicSpellCheckEvent = new BasicSpellCheckEvent(string, (List)object, wordTokenizer);
            bl = this.fireAndHandleEvent(wordTokenizer, basicSpellCheckEvent);
        }
        if (bl) {
            return -2;
        }
        if (n == 0) {
            return -1;
        }
        return n;
    }

    private boolean isSupposedToBeCapitalized(String string, WordTokenizer wordTokenizer) {
        boolean bl = !this.config.getBoolean("SPELL_IGNORESENTENCECAPTILIZATION");
        return bl && wordTokenizer.isNewSentence() && Character.isLowerCase(string.charAt(0));
    }
}

