/*
 * Decompiled with CFR 0.152.
 */
package org.fife.com.swabunga.spell.event;

import java.text.BreakIterator;
import org.fife.com.swabunga.spell.event.Word;
import org.fife.com.swabunga.spell.event.WordFinder;
import org.fife.com.swabunga.spell.event.WordNotFoundException;

public abstract class AbstractWordFinder
implements WordFinder {
    protected Word currentWord;
    protected Word nextWord;
    protected boolean startsSentence;
    protected String text;
    protected BreakIterator sentenceIterator;

    public AbstractWordFinder(String string) {
        this.text = string;
        this.setup();
    }

    public AbstractWordFinder() {
        this.text = "";
        this.setup();
    }

    public abstract Word next();

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.setup();
    }

    public Word current() {
        if (this.currentWord == null) {
            throw new WordNotFoundException("No Words in current String");
        }
        return this.currentWord;
    }

    public boolean hasNext() {
        return this.nextWord != null;
    }

    public void replace(String string) {
        if (this.currentWord == null) {
            throw new WordNotFoundException("No Words in current String");
        }
        StringBuffer stringBuffer = new StringBuffer(this.text.substring(0, this.currentWord.getStart()));
        stringBuffer.append(string);
        stringBuffer.append(this.text.substring(this.currentWord.getEnd()));
        int n = string.length() - this.currentWord.getText().length();
        this.currentWord.setText(string);
        if (this.nextWord != null) {
            this.nextWord.setStart(this.nextWord.getStart() + n);
        }
        this.text = stringBuffer.toString();
        this.sentenceIterator.setText(this.text);
        int n2 = this.currentWord.getStart();
        this.sentenceIterator.following(n2);
        this.startsSentence = this.sentenceIterator.current() == n2;
    }

    public boolean startsSentence() {
        if (this.currentWord == null) {
            throw new WordNotFoundException("No Words in current String");
        }
        return this.startsSentence;
    }

    public String toString() {
        return this.text;
    }

    protected void setSentenceIterator(Word word) {
        int n = this.sentenceIterator.current();
        if (n == this.currentWord.getStart()) {
            this.startsSentence = true;
        } else {
            this.startsSentence = false;
            if (this.currentWord.getEnd() > n) {
                this.sentenceIterator.next();
            }
        }
    }

    protected boolean isWordChar(int n) {
        boolean bl = false;
        char c = this.text.charAt(n);
        if (n == 0 || n == this.text.length() - 1) {
            return Character.isLetterOrDigit(c);
        }
        char c2 = this.text.charAt(n - 1);
        char c3 = this.text.charAt(n + 1);
        switch (c) {
            case '\'': 
            case '.': 
            case '@': 
            case '_': {
                bl = Character.isLetterOrDigit(c2) && Character.isLetterOrDigit(c3);
                break;
            }
            default: {
                bl = Character.isLetterOrDigit(c);
            }
        }
        return bl;
    }

    protected int ignore(int n, char c) {
        return this.ignore(n, new Character(c), null);
    }

    protected int ignore(int n, char c, char c2) {
        return this.ignore(n, new Character(c), new Character(c2));
    }

    protected int ignore(int n, Character c, Character c2) {
        Character c3;
        int n2 = n;
        if (n2 < this.text.length() && (c3 = new Character(this.text.charAt(n2))).equals(c)) {
            ++n2;
            while (n2 < this.text.length()) {
                c3 = new Character(this.text.charAt(n2));
                if (c2 != null && c3.equals(c2)) {
                    ++n2;
                    break;
                }
                if (c2 == null && !Character.isLetterOrDigit(c3.charValue())) break;
                ++n2;
            }
        }
        return n2;
    }

    protected int ignore(int n, String string, String string2) {
        String string3;
        int n2 = n;
        int n3 = this.text.length();
        int n4 = string.length();
        int n5 = string2.length();
        if (n2 + n4 < n3 && (string3 = this.text.substring(n2, n2 + n4)).equals(string)) {
            n2 += n4;
            while (n2 != this.text.length() - n5) {
                String string4 = this.text.substring(n2, n2 + n5);
                if (string4.equals(string2)) {
                    n2 += n5;
                    break;
                }
                ++n2;
            }
        }
        return n2;
    }

    protected void init() {
        this.sentenceIterator = BreakIterator.getSentenceInstance();
        this.sentenceIterator.setText(this.text);
    }

    private void setup() {
        this.currentWord = new Word("", 0);
        this.nextWord = new Word("", 0);
        this.startsSentence = true;
        this.init();
        try {
            this.next();
        }
        catch (WordNotFoundException wordNotFoundException) {
            this.currentWord = null;
            this.nextWord = null;
        }
    }
}

