/*
 * Decompiled with CFR 0.152.
 */
package org.fife.com.swabunga.spell.engine;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.fife.com.swabunga.spell.engine.Configuration;

public class EditDistance {
    public static final Configuration config = Configuration.getConfiguration();
    static final int costOfDeletingSourceCharacter = config.getInteger("EDIT_DEL1");
    static final int costOfInsertingSourceCharacter = config.getInteger("EDIT_DEL2");
    static final int costOfSubstitutingLetters = config.getInteger("EDIT_SUB");
    static final int costOfSwappingLetters = config.getInteger("EDIT_SWAP");
    static final int costOfChangingCase = config.getInteger("EDIT_CASE");

    public static final int getDistance(String string, String string2) {
        return EditDistance.getDistance(string, string2, null);
    }

    public static final int getDistance(String string, String string2, int[][] nArray) {
        int n;
        int n2;
        char c = '\u0000';
        char c2 = '\u0000';
        int n3 = string.length() + 1;
        int n4 = string2.length() + 1;
        if (nArray == null || nArray.length < n3 || nArray[0].length < n4) {
            nArray = new int[n3][n4];
        }
        nArray[0][0] = 0;
        for (n2 = 1; n2 != n3; ++n2) {
            nArray[n2][0] = nArray[n2 - 1][0] + costOfInsertingSourceCharacter;
        }
        for (n = 1; n != n4; ++n) {
            nArray[0][n] = nArray[0][n - 1] + costOfDeletingSourceCharacter;
        }
        for (n2 = 1; n2 != n3; ++n2) {
            c = string.charAt(n2 - 1);
            for (n = 1; n != n4; ++n) {
                boolean bl;
                c2 = string2.charAt(n - 1);
                if (c == c2) {
                    nArray[n2][n] = nArray[n2 - 1][n - 1];
                    continue;
                }
                int n5 = costOfSubstitutingLetters + nArray[n2 - 1][n - 1];
                int n6 = Integer.MAX_VALUE;
                boolean bl2 = bl = n2 != 1 && n != 1 && c == string2.charAt(n - 2) && string.charAt(n2 - 2) == c2;
                if (bl) {
                    n6 = costOfSwappingLetters + nArray[n2 - 2][n - 2];
                }
                int n7 = costOfDeletingSourceCharacter + nArray[n2][n - 1];
                int n8 = costOfInsertingSourceCharacter + nArray[n2 - 1][n];
                int n9 = Integer.MAX_VALUE;
                if (EditDistance.equalIgnoreCase(c, c2)) {
                    n9 = costOfChangingCase + nArray[n2 - 1][n - 1];
                }
                nArray[n2][n] = EditDistance.minimum(n5, n6, n7, n8, n9);
            }
        }
        return nArray[n3 - 1][n4 - 1];
    }

    private static boolean equalIgnoreCase(char c, char c2) {
        if (c == c2) {
            return true;
        }
        return Character.toLowerCase(c) == Character.toLowerCase(c2);
    }

    private static int minimum(int n, int n2, int n3, int n4, int n5) {
        int n6 = n;
        if (n2 < n6) {
            n6 = n2;
        }
        if (n3 < n6) {
            n6 = n3;
        }
        if (n4 < n6) {
            n6 = n4;
        }
        if (n5 < n6) {
            n6 = n5;
        }
        return n6;
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        int[][] nArray = new int[0][0];
        while ((string2 = bufferedReader.readLine()) != null && string2.length() != 0 && (string = bufferedReader.readLine()) != null && string.length() != 0) {
            System.out.println(EditDistance.getDistance(string2, string, nArray));
        }
        System.out.println("done");
    }
}

