/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.parser;

import java.io.IOException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.io.DocumentReader;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends AbstractParser {
    private SAXParserFactory spf;
    private DefaultParseResult result;
    private EntityResolver entityResolver;

    public XmlParser() {
        this(null);
    }

    public XmlParser(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        this.result = new DefaultParseResult(this);
        try {
            this.spf = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
    }

    public boolean isValidating() {
        return this.spf.isValidating();
    }

    public ParseResult parse(RSyntaxDocument rSyntaxDocument, String string) {
        this.result.clearNotices();
        Element element = rSyntaxDocument.getDefaultRootElement();
        this.result.setParsedLines(0, element.getElementCount() - 1);
        if (this.spf == null || rSyntaxDocument.getLength() == 0) {
            return this.result;
        }
        try {
            SAXParser sAXParser = this.spf.newSAXParser();
            Handler handler = new Handler(rSyntaxDocument);
            DocumentReader documentReader = new DocumentReader(rSyntaxDocument);
            InputSource inputSource = new InputSource(documentReader);
            sAXParser.parse(inputSource, (DefaultHandler)handler);
            documentReader.close();
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            this.result.addNotice(new DefaultParserNotice(this, "Error parsing XML: " + exception.getMessage(), 0, -1, -1));
        }
        return this.result;
    }

    public void setValidating(boolean bl) {
        this.spf.setValidating(bl);
    }

    private class Handler
    extends DefaultHandler {
        private Document doc;

        private Handler(Document document) {
            this.doc = document;
        }

        private void doError(SAXParseException sAXParseException, int n) {
            int n2 = sAXParseException.getLineNumber() - 1;
            Element element = this.doc.getDefaultRootElement();
            Element element2 = element.getElement(n2);
            int n3 = element2.getStartOffset();
            int n4 = element2.getEndOffset() - n3;
            if (n2 == element.getElementCount() - 1) {
                ++n4;
            }
            DefaultParserNotice defaultParserNotice = new DefaultParserNotice(XmlParser.this, sAXParseException.getMessage(), n2, n3, n4);
            defaultParserNotice.setLevel(n);
            XmlParser.this.result.addNotice(defaultParserNotice);
        }

        public void error(SAXParseException sAXParseException) {
            this.doError(sAXParseException, 0);
        }

        public void fatalError(SAXParseException sAXParseException) {
            this.doError(sAXParseException, 0);
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (XmlParser.this.entityResolver != null) {
                try {
                    return XmlParser.this.entityResolver.resolveEntity(string, string2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return super.resolveEntity(string, string2);
        }

        public void warning(SAXParseException sAXParseException) {
            this.doError(sAXParseException, 1);
        }
    }
}

