/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;

public class DefaultToken
extends Token {
    public DefaultToken() {
    }

    public DefaultToken(Segment segment, int n, int n2, int n3, int n4) {
        this(segment.array, n, n2, n3, n4);
    }

    public DefaultToken(char[] cArray, int n, int n2, int n3, int n4) {
        super(cArray, n, n2, n3, n4);
    }

    public int getListOffset(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f, float f2) {
        if (f >= f2) {
            return this.offset;
        }
        float f3 = f;
        float f4 = f;
        float f5 = f;
        int n = this.offset;
        FontMetrics fontMetrics = null;
        for (Token token = this; token != null && token.isPaintable(); token = token.getNextToken()) {
            fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(token.type);
            char[] cArray = token.text;
            int n2 = token.textOffset;
            int n3 = n2 + token.textCount;
            for (int i = n2; i < n3; ++i) {
                f3 = f4;
                if (cArray[i] == '\t') {
                    f5 = f4 = tabExpander.nextTabStop(f4, 0);
                    n2 = i + 1;
                } else {
                    f4 = f5 + (float)fontMetrics.charsWidth(cArray, n2, i - n2 + 1);
                }
                if (!(f2 >= f3) || !(f2 < f4)) continue;
                if (f2 - f3 < f4 - f2) {
                    return n + i - token.textOffset;
                }
                return n + i + 1 - token.textOffset;
            }
            f5 = f4;
            n += token.textCount;
        }
        return n;
    }

    public float getWidthUpTo(int n, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f) {
        float f2 = f;
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.type);
        if (fontMetrics != null) {
            int n2;
            int n3 = this.textOffset;
            int n4 = this.textOffset + n;
            for (int i = n3; i < n4; ++i) {
                if (this.text[i] != '\t') continue;
                n2 = i - n3;
                if (n2 > 0) {
                    f2 += (float)fontMetrics.charsWidth(this.text, n3, n2);
                }
                n3 = i + 1;
                f2 = tabExpander.nextTabStop(f2, 0);
            }
            n2 = n4 - n3;
            f2 += (float)fontMetrics.charsWidth(this.text, n3, n2);
        }
        return f2 - f;
    }

    public Rectangle listOffsetToView(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, int n, int n2, Rectangle rectangle) {
        int n3 = n2;
        FontMetrics fontMetrics = null;
        Segment segment = new Segment();
        for (Token token = this; token != null && token.isPaintable(); token = token.getNextToken()) {
            fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(token.type);
            if (fontMetrics == null) {
                return rectangle;
            }
            char[] cArray = token.text;
            int n4 = token.textOffset;
            int n5 = n4 + token.textCount;
            if (token.containsPosition(n)) {
                segment.array = token.text;
                segment.offset = token.textOffset;
                segment.count = n - token.offset;
                int n6 = Utilities.getTabbedTextWidth(segment, fontMetrics, n3, tabExpander, token.offset);
                rectangle.x = n3 + n6;
                n5 = token.documentToToken(n);
                rectangle.width = cArray[n5] == '\t' ? fontMetrics.charWidth(' ') : fontMetrics.charWidth(cArray[n5]);
                return rectangle;
            }
            segment.array = token.text;
            segment.offset = token.textOffset;
            segment.count = token.textCount;
            n3 += Utilities.getTabbedTextWidth(segment, fontMetrics, n3, tabExpander, token.offset);
        }
        rectangle.x = n3;
        rectangle.width = 1;
        return rectangle;
    }

    public float paint(Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f3) {
        int n;
        int n2 = (int)f;
        int n3 = this.textOffset + this.textCount;
        float f4 = f;
        int n4 = 0;
        int n5 = this.textOffset;
        Color color = rSyntaxTextArea.getForegroundForToken(this);
        Color color2 = rSyntaxTextArea.getBackgroundForToken(this);
        graphics2D.setFont(rSyntaxTextArea.getFontForTokenType(this.type));
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.type);
        block3: for (n = this.textOffset; n < n3; ++n) {
            switch (this.text[n]) {
                case '\t': {
                    f4 = tabExpander.nextTabStop(f + (float)fontMetrics.charsWidth(this.text, n5, n4), 0);
                    if (color2 != null) {
                        this.paintBackground(f, f2, f4 - f, fontMetrics.getHeight(), graphics2D, fontMetrics.getAscent(), rSyntaxTextArea, color2);
                    }
                    if (n4 > 0) {
                        graphics2D.setColor(color);
                        graphics2D.drawChars(this.text, n5, n4, (int)f, (int)f2);
                        n4 = 0;
                    }
                    n5 = n + 1;
                    f = f4;
                    continue block3;
                }
                default: {
                    ++n4;
                }
            }
        }
        f4 = f + (float)fontMetrics.charsWidth(this.text, n5, n4);
        if (n4 > 0 && f4 >= f3) {
            if (color2 != null) {
                this.paintBackground(f, f2, f4 - f, fontMetrics.getHeight(), graphics2D, fontMetrics.getAscent(), rSyntaxTextArea, color2);
            }
            graphics2D.setColor(color);
            graphics2D.drawChars(this.text, n5, n4, (int)f, (int)f2);
        }
        if (rSyntaxTextArea.getUnderlineForToken(this)) {
            graphics2D.setColor(color);
            n = (int)(f2 + 1.0f);
            graphics2D.drawLine(n2, n, (int)f4, n);
        }
        if (rSyntaxTextArea.getPaintTabLines() && n2 == rSyntaxTextArea.getMargin().left) {
            this.paintTabLines(n2, (int)f2, (int)f4, graphics2D, tabExpander, rSyntaxTextArea);
        }
        return f4;
    }
}

